/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.wizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.form.AddExistingProjectForm;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.BindProjectModel;
import org.eclipse.codewind.intellij.ui.wizard.ConfirmProjectTypeStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFolderStep
extends AbstractBindProjectWizardStep {
    public static String STEP_ID = "ProjectFolderStep";
    private AddExistingProjectForm form;
    private Project project;
    private CodewindConnection connection;

    public ProjectFolderStep(@Nullable String title, Project project, CodewindConnection connection) {
        super(title);
        this.project = project;
        this.connection = connection;
    }

    @NotNull
    public Object getStepId() {
        String string = STEP_ID;
        if (string == null) {
            ProjectFolderStep.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Object getNextStepId() {
        return ConfirmProjectTypeStep.STEP_ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return !this.form.getProjectPath().isEmpty() && !this.form.isProjectAlreadyAdded();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        if (this.form != null) {
            return this.form.getContentPane();
        }
        this.form = new AddExistingProjectForm(this, this.project, this.connection);
        String basePath = this.project.getBasePath().toString();
        boolean isCodewindProject = this.form.isCodewindProject(basePath);
        if (!isCodewindProject) {
            this.form.setProjectPath(basePath);
        }
        return this.form.getContentPane();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getProjectPath() {
        return this.form.getProjectPath();
    }

    @Override
    protected void onStepEntering(BindProjectModel model) {
    }

    @Override
    protected void onStepLeaving(BindProjectModel model) {
        if (!this.getProjectPath().equals(model.getProjectPath())) {
            model.setProjectTypeInfo(null);
            model.setSubtypeInfo(null);
        }
        model.setProjectPath(this.getProjectPath());
    }

    @Override
    protected void postDoNextStep(BindProjectModel model) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/wizard/ProjectFolderStep", "getStepId"));
    }
}

