/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.ConnectionEnv;
import org.eclipse.codewind.intellij.ui.tasks.RefreshTask;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeModel;
import org.jetbrains.annotations.NotNull;

public class OpenTektonDashboardAction
extends AnAction {
    public OpenTektonDashboardAction() {
        super("Open Tekton Dashboard");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            OpenTektonDashboardAction.$$$reportNull$$$0(0);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            Logger.log("unrecognized component for OpenTektonDashboardAction: " + data);
            System.out.println("*** unrecognized component for OpenTektonDashboardAction: " + data);
            return;
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            Logger.log("no selection for OpenTektonDashboardAction: " + data);
            System.out.println("*** no selection for OpenTektonDashboardAction: " + data);
            return;
        }
        Object node = treePath.getLastPathComponent();
        ProgressManager.getInstance().run((Task)new RefreshTask(node, tree));
        CodewindTreeModel model = (CodewindTreeModel)((Object)tree.getModel());
        if (node instanceof CodewindApplication) {
            URL tektonURL;
            CodewindApplication app = (CodewindApplication)node;
            ConnectionEnv.TektonDashboard tekton = app.getConnection().getTektonDashboard();
            if (tekton.hasTektonDashboard() && (tektonURL = tekton.getTektonUrl()) != null) {
                try {
                    BrowserLauncher.getInstance().browse(tektonURL.toURI());
                }
                catch (URISyntaxException use) {
                    Logger.log("Bad Tekton Dashboard URL: " + tektonURL);
                    System.out.println("*** Bad Tekton Dashboard URL: " + tektonURL);
                }
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/actions/OpenTektonDashboardAction", "actionPerformed"));
    }
}

