/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Logger {
    @NotNull
    private static com.intellij.openapi.diagnostic.Logger getLogger() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length < 2) {
            com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)"Codewind");
            if (logger == null) {
                Logger.$$$reportNull$$$0(0);
            }
            return logger;
        }
        Stream<StackTraceElement> stream = Arrays.stream(stackTrace, 2, stackTrace.length);
        String category = stream.map(StackTraceElement::getClassName).filter(className -> !className.equals(Logger.class.getName())).findFirst().map(name -> "#" + name).orElse("Codewind");
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(1);
        }
        return logger;
    }

    public static void logWarning(String msg) {
        Logger.getLogger().warn(msg);
    }

    public static void logWarning(String msg, Throwable t) {
        Logger.getLogger().warn(msg, t);
    }

    public static void logWarning(Throwable t) {
        Logger.getLogger().warn(t);
    }

    public static void log(String msg) {
        Logger.getLogger().info(msg);
    }

    public static void log(String msg, Throwable t) {
        Logger.getLogger().info(msg, t);
    }

    public static void log(Throwable t) {
        Logger.getLogger().info(t);
    }

    public static Throwable unwrap(Throwable error) {
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/core/Logger", "getLogger"));
    }
}

