"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const ProjectToWatch_1 = require("./ProjectToWatch");
/**
 * The watcher WebSocket will inform of us of project watch changes just like
 * the GET watchlist API, except that the WebSocket JSON has an additional field
 * 'changeType' which specifies how the watched project changed: for example, if
 * a project is deleted or created, this field will indicate as such.
 *
 * Absent the above field, this object has the same structure as its parent.
 */
class ProjectToWatchFromWebSocket extends ProjectToWatch_1.ProjectToWatch {
    get changeType() {
        return this._changeType;
    }
    static cloneWebSocketWithNewProjectCreationTime(old, projectCreationTimeInAbsoluteMsecsParam) {
        const result = new ProjectToWatchFromWebSocket();
        ProjectToWatch_1.ProjectToWatch.copyWithNewProjectCreationTime(result, old, projectCreationTimeInAbsoluteMsecsParam);
        result._changeType = old._changeType;
        return result;
    }
    static create(json) {
        const result = new ProjectToWatchFromWebSocket();
        ProjectToWatch_1.ProjectToWatch.innerCreateFromJson(result, json, json.changeType.toLowerCase() === "delete");
        result._changeType = json.changeType;
        return result;
    }
    constructor() {
        // json: models.IWatchedProjectJson
        super();
        // super(json, json.changeType.toLowerCase() === "delete");
        // this._changeType = json.changeType;
    }
}
exports.ProjectToWatchFromWebSocket = ProjectToWatchFromWebSocket;
