/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindApplicationFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindSocket;
import org.eclipse.codewind.core.internal.connection.ConnectionEnv;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.codewind.filewatchers.eclipse.CodewindFilewatcherdConnection;
import org.eclipse.codewind.filewatchers.eclipse.ICodewindProjectTranslator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindConnection {
    public static final String CODEWIND_WORKSPACE_PROPERTY = "org.eclipse.codewind.internal.workspace";
    private static final String BRANCH_VERSION = "\\d{4}_M\\d{1,2}_\\D";
    private static final Pattern pattern = Pattern.compile("\\d{4}_M\\d{1,2}_\\D");
    private String name;
    private URI baseUri;
    private ConnectionEnv env = null;
    private String connectionErrorMsg = null;
    private CodewindSocket socket;
    private CodewindFilewatcherdConnection filewatcher;
    private volatile boolean isConnected = false;
    private Map<String, CodewindApplication> appMap = new LinkedHashMap<String, CodewindApplication>();

    public CodewindConnection(String name, URI uri) {
        this.setName(name);
        this.setBaseURI(uri);
    }

    public void connect(IProgressMonitor monitor) throws IOException, URISyntaxException, JSONException {
        if (this.isConnected) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        mon.setTaskName(NLS.bind((String)Messages.Connection_TaskLabel, (Object)this.baseUri));
        if (!this.waitForReady((IProgressMonitor)mon.split(20))) {
            if (mon.isCanceled()) {
                return;
            }
            Logger.logError("Timed out waiting for Codewind to go into ready state.");
            this.onInitFail(Messages.Connection_ErrConnection_CodewindNotReady);
        }
        mon.split(25);
        this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri));
        Logger.log("Codewind version is: " + this.env.getVersion());
        if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
            Logger.logError("The detected version of Codewind is not supported: " + this.env.getVersion() + ", url: " + this.baseUri);
            this.onInitFail(NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)InstallUtil.INSTALL_VERSION));
        }
        if (mon.isCanceled()) {
            return;
        }
        this.socket = new CodewindSocket(this);
        if (!this.socket.blockUntilFirstConnection((IProgressMonitor)mon.split(35))) {
            Logger.logError("Socket failed to connect: " + this.socket.socketUri);
            this.close();
            throw new CodewindConnectionException(this.socket.socketUri);
        }
        if (mon.isCanceled()) {
            this.socket.close();
            return;
        }
        File cwctl = new File(CLIUtil.getCWCTLExecutable());
        this.filewatcher = new CodewindFilewatcherdConnection(this.baseUri.toString(), cwctl, new ICodewindProjectTranslator(){

            public Optional<String> getProjectId(IProject project) {
                CodewindApplication app;
                if (project != null && (app = CodewindConnection.this.getAppByName(project.getName())) != null) {
                    return Optional.of(app.projectID);
                }
                return Optional.empty();
            }
        });
        if (mon.isCanceled()) {
            this.close();
            return;
        }
        this.isConnected = true;
        Logger.log("Connected to: " + this);
        mon.split(20);
        this.refreshApps(null);
    }

    public String getSocketNamespace() {
        return this.env.getSocketNamespace();
    }

    public CodewindSocket getSocket() {
        return this.socket;
    }

    private void onInitFail(String msg) throws ConnectException {
        Logger.log("Initializing Codewind connection failed: " + msg);
        this.close();
        throw new ConnectException(msg);
    }

    public void close() {
        Logger.log("Closing " + this);
        this.isConnected = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.filewatcher != null) {
            this.filewatcher.dispose();
        }
        for (CodewindApplication app : this.appMap.values()) {
            app.dispose();
        }
        this.appMap.clear();
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    public void setBaseURI(URI uri) {
        this.baseUri = uri != null && !uri.toString().endsWith("/") ? uri.resolve("/") : uri;
    }

    private static JSONObject getEnvData(URI baseUrl) throws JSONException, IOException {
        URI envUrl = baseUrl.resolve("api/v1/environment");
        String envResponse = null;
        try {
            envResponse = HttpUtil.get((URI)envUrl).response;
        }
        catch (IOException e) {
            Logger.logError("Error contacting Environment endpoint", e);
            throw e;
        }
        return new JSONObject(envResponse);
    }

    public static String getVersion(URI baseURI) {
        try {
            ConnectionEnv env = new ConnectionEnv(CodewindConnection.getEnvData(baseURI));
            return env.getVersion();
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to get the Codewind version.", e);
            return null;
        }
    }

    public static boolean isSupportedVersion(String versionStr) {
        if ("unknown".equals(versionStr)) {
            return false;
        }
        if ("latest".equals(versionStr)) {
            return true;
        }
        Matcher matcher = pattern.matcher(versionStr);
        if (matcher.matches()) {
            return true;
        }
        try {
            String[] expectedDigits = InstallUtil.INSTALL_VERSION.split("\\.");
            String[] actualDigits = versionStr.split("\\.");
            for (int i = 0; i < expectedDigits.length; ++i) {
                int expectedVal = Integer.parseInt(expectedDigits[i]);
                if (i >= actualDigits.length) {
                    if (expectedVal == 0) continue;
                    return false;
                }
                int actualVal = Integer.parseInt(actualDigits[i]);
                if (actualVal < expectedVal) {
                    return false;
                }
                if (actualVal <= expectedVal) continue;
                return true;
            }
            return true;
        }
        catch (NumberFormatException e) {
            Logger.logError("Couldn't parse version number from: " + versionStr);
            return false;
        }
    }

    public boolean checkVersion(int requiredVersion, String requiredVersionBr) {
        String versionStr = this.env.getVersion();
        if ("unknown".equals(versionStr)) {
            return false;
        }
        if ("latest".equals(versionStr)) {
            return true;
        }
        Matcher matcher = pattern.matcher(versionStr);
        if (matcher.matches()) {
            String actualYear = versionStr.substring(0, 4);
            String requiredYear = requiredVersionBr.substring(0, 4);
            try {
                if (Integer.parseInt(actualYear) >= Integer.parseInt(requiredYear)) {
                    int index = versionStr.lastIndexOf(95);
                    String actualIteration = versionStr.substring(6, index);
                    index = requiredVersionBr.lastIndexOf(95);
                    String requiredIteration = requiredVersionBr.substring(6, index);
                    if (Integer.parseInt(actualIteration) >= Integer.parseInt(requiredIteration)) {
                        return true;
                    }
                }
            }
            catch (NumberFormatException e) {
                Logger.logError("Failed to parse the actual version: " + versionStr + ", or the required version: " + requiredVersionBr);
            }
            return false;
        }
        try {
            return Integer.parseInt(versionStr) >= requiredVersion;
        }
        catch (NumberFormatException e) {
            Logger.logError("Couldn't parse version number from " + versionStr);
            return false;
        }
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void refreshApps(String projectID) {
        URI projectsURL = this.baseUri.resolve("api/v1/projects");
        try {
            String projectsResponse = HttpUtil.get((URI)projectsURL).response;
            CodewindApplicationFactory.getAppsFromProjectsJson(this, projectsResponse, projectID);
            Logger.log("App list update success");
        }
        catch (Exception e) {
            CoreUtil.openDialog(true, Messages.Connection_ErrGettingProjectListTitle, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(CodewindApplication app) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.put(app.projectID, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodewindApplication> getApps() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new ArrayList<CodewindApplication>(this.appMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAppIds() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new HashSet<String>(this.appMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String projectID) {
        CodewindApplication app = null;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            app = this.appMap.remove(projectID);
        }
        if (app != null) {
            Logger.log("Removing the " + app.name + " application with id: " + projectID);
            CoreUtil.removeApplication(app);
            app.dispose();
        } else {
            Logger.log("No application found for deleted project: " + projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByID(String projectID) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return this.appMap.get(projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByName(String name) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!app.name.equals(name)) continue;
                return app;
            }
        }
        Logger.log("No application found for name " + name);
        return null;
    }

    public boolean waitForReady(IProgressMonitor monitor) throws IOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                mon.split(10);
                if (this.requestCodewindReady(500, 500)) {
                    return true;
                }
                if (mon.isCanceled()) {
                    return false;
                }
                Thread.sleep(500L);
                if (!mon.isCanceled()) continue;
                return false;
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
        return false;
    }

    public boolean requestCodewindReady(int connectTimeoutMS, int readTimeoutMS) throws IOException {
        String endpoint = "ready";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, connectTimeoutMS, readTimeoutMS);
        this.checkResult(result, uri, true);
        return "true".equals(result.response);
    }

    public void requestProjectRestart(CodewindApplication app, String launchMode) throws JSONException, IOException {
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + "restart";
        URI url = this.baseUri.resolve(restartEndpoint);
        JSONObject restartProjectPayload = new JSONObject();
        restartProjectPayload.put("startMode", (Object)launchMode);
        HttpUtil.HttpResult result = HttpUtil.post(url, restartProjectPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        app.invalidatePorts();
    }

    public void requestProjectOpenClose(CodewindApplication app, boolean enable) throws JSONException, IOException {
        String action = enable ? "open" : "close";
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + action;
        URI url = this.baseUri.resolve(restartEndpoint);
        HttpUtil.HttpResult result = HttpUtil.put(url);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public JSONObject requestProjectStatus(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but null response when getting initial state");
        }
        JSONArray allProjectStatuses = new JSONArray(result.response);
        for (int i = 0; i < allProjectStatuses.length(); ++i) {
            JSONObject projectStatus = allProjectStatuses.getJSONObject(i);
            if (!projectStatus.getString("projectID").equals(app.projectID)) continue;
            return projectStatus;
        }
        Logger.log("Didn't find status info for project " + app.name);
        return null;
    }

    public JSONObject requestProjectMetricsStatus(CodewindApplication app) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "metrics/status";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        return new JSONObject(result.response);
    }

    public void requestProjectBuild(CodewindApplication app, String action) throws JSONException, IOException {
        long syncTime = System.currentTimeMillis();
        String[] fileList = this.requestUploadsRecursively(app.projectID, app.fullLocalPath.toOSString(), app.getLastSync());
        this.requestProjectClear(app, fileList);
        Logger.log("Sync complete for " + app.name + " to " + app.connection.baseUri + " in " + (System.currentTimeMillis() - syncTime) + "ms");
        app.setLastSync(syncTime);
        String buildEndpoint = "api/v1/projects/" + app.projectID + "/" + "build";
        URI url = this.baseUri.resolve(buildEndpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("action", (Object)action);
        HttpUtil.post(url, buildPayload);
    }

    public List<ProjectLogInfo> requestProjectLogs(CodewindApplication app) throws JSONException, IOException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        JSONObject logs = new JSONObject(result.response);
        JSONArray buildLogs = logs.getJSONArray("build");
        logList.addAll(CodewindConnection.getLogs(buildLogs, "build"));
        JSONArray appLogs = logs.getJSONArray("app");
        logList.addAll(CodewindConnection.getLogs(appLogs, "app"));
        return logList;
    }

    public static List<ProjectLogInfo> getLogs(JSONArray logs, String type) throws JSONException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        if (logs != null) {
            for (int i = 0; i < logs.length(); ++i) {
                JSONObject log = logs.getJSONObject(i);
                if (log.has("logName")) {
                    String logName = log.getString("logName");
                    if ("-".equals(logName)) continue;
                    String workspacePath = null;
                    if (log.has("workspaceLogPath")) {
                        workspacePath = log.getString("workspaceLogPath");
                    }
                    ProjectLogInfo logInfo = new ProjectLogInfo(type, logName, workspacePath);
                    logList.add(logInfo);
                    continue;
                }
                Logger.log("An item in the log list does not have the key: logName");
            }
        }
        return logList;
    }

    public void requestEnableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri);
        this.checkResult(result, uri, false);
    }

    public void requestDisableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri);
        this.checkResult(result, uri, false);
    }

    public void requestValidate(CodewindApplication app) throws JSONException, IOException {
        boolean projectIdInPath = this.checkVersion(1901, "2019_M1_E");
        String endpoint = projectIdInPath ? "api/v1/projects/" + app.projectID + "/" + "validate" : "api/v1/validate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        if (!projectIdInPath) {
            buildPayload.put("projectID", (Object)app.projectID);
        }
        buildPayload.put("projectType", (Object)app.projectType.getId());
        HttpUtil.HttpResult result = HttpUtil.post(url, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public void requestValidateGenerate(CodewindApplication app) throws JSONException, IOException {
        boolean projectIdInPath = this.checkVersion(1901, "2019_M1_E");
        String endpoint = projectIdInPath ? "api/v1/projects/" + app.projectID + "/" + "validate/generate" : "api/v1/validate/generate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        if (!projectIdInPath) {
            buildPayload.put("projectID", (Object)app.projectID);
        }
        buildPayload.put("projectType", (Object)app.projectType.getId());
        buildPayload.put("autoGenerate", true);
        HttpUtil.HttpResult result = HttpUtil.post(url, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        this.requestValidate(app);
    }

    public JSONObject requestProjectCapabilities(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects/" + app.projectID + "/" + "capabilities");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but empty content when getting project capabilities");
        }
        JSONObject capabilities = new JSONObject(result.response);
        return capabilities;
    }

    public List<ProjectTemplateInfo> requestProjectTemplates(boolean enabledOnly) throws IOException, JSONException, URISyntaxException {
        ArrayList<ProjectTemplateInfo> templates = new ArrayList<ProjectTemplateInfo>();
        URI uri = this.baseUri.resolve("api/v1/templates");
        if (enabledOnly) {
            String query = "showEnabledOnly=true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
        }
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, false);
        if (result.responseCode == 204) {
            return templates;
        }
        JSONArray templateArray = new JSONArray(result.response);
        for (int i = 0; i < templateArray.length(); ++i) {
            templates.add(new ProjectTemplateInfo(templateArray.getJSONObject(i)));
        }
        return templates;
    }

    public List<RepositoryInfo> requestRepositories() throws IOException, JSONException {
        ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        JSONArray repoArray = new JSONArray(result.response);
        for (int i = 0; i < repoArray.length(); ++i) {
            repos.add(new RepositoryInfo(repoArray.getJSONObject(i)));
        }
        return repos;
    }

    public void requestRepoEnable(String repoUrl, boolean enable) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/batch/templates/repositories");
        JSONArray payload = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("op", (Object)"enable");
        obj.put("url", (Object)repoUrl);
        obj.put("value", (Object)(enable ? "true" : "false"));
        payload.put((Object)obj);
        HttpUtil.HttpResult result = HttpUtil.patch(uri, payload);
        this.checkResult(result, uri, false);
    }

    public void requestRepoAdd(String url, String name, String description) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        JSONObject payload = new JSONObject();
        payload.put("url", (Object)url);
        if (name != null && !name.isEmpty()) {
            payload.put("name", (Object)name);
        }
        if (description != null && !description.isEmpty()) {
            payload.put("description", (Object)description);
        }
        payload.put("enabled", true);
        HttpUtil.HttpResult result = HttpUtil.post(uri, payload);
        this.checkResult(result, uri, false);
    }

    public void requestRepoRemove(String url) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        JSONObject payload = new JSONObject();
        payload.put("url", (Object)url);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, payload);
        this.checkResult(result, uri, false);
    }

    public void requestProjectBind(String name, String path, String language, String projectType) throws JSONException, IOException {
        String bindStartEndpoint = "api/v1/projects/remote-bind/start";
        URI bindStartUri = this.baseUri.resolve(bindStartEndpoint);
        long initialSyncTime = System.currentTimeMillis();
        JSONObject bindStartPayload = new JSONObject();
        bindStartPayload.put("name", (Object)name);
        bindStartPayload.put("path", (Object)CoreUtil.getContainerPath(path));
        bindStartPayload.put("language", (Object)language);
        if (projectType == null) {
            projectType = ProjectType.getTypeFromLanguage(language).getId();
        }
        if (projectType != null) {
            bindStartPayload.put("projectType", (Object)projectType);
        }
        bindStartPayload.put("autoBuild", true);
        HttpUtil.HttpResult bindStartResult = HttpUtil.post(bindStartUri, bindStartPayload, 300);
        this.checkResult(bindStartResult, bindStartUri, false);
        JSONObject projectInf = new JSONObject(bindStartResult.response);
        String projectID = projectInf.getString("projectID");
        this.requestUploadsRecursively(projectID, path, 0L);
        String bindEndEndpoint = "api/v1/projects/" + projectID + "/" + "remote-bind/end";
        URI bindEndUri = this.baseUri.resolve(bindEndEndpoint);
        HttpUtil.HttpResult bindEndResult = HttpUtil.post(bindEndUri);
        this.checkResult(bindEndResult, bindEndUri, false);
        CodewindApplication newApp = this.getAppByID(projectID);
        if (newApp != null) {
            newApp.setLastSync(initialSyncTime);
        }
        Logger.log("Initial project upload complete for " + name + " to " + this.baseUri + " in " + (System.currentTimeMillis() - initialSyncTime) + "ms");
        CoreUtil.updateConnection(this);
    }

    public String[] requestUploadsRecursively(String projectId, String path, long lastSyncMs) throws JSONException, IOException {
        LinkedList fileList = new LinkedList();
        Path basePath = Paths.get(path, new String[0]);
        Files.walk(basePath, new FileVisitOption[0]).forEach(fullPath -> {
            Path relative = basePath.relativize((Path)fullPath);
            fileList.add(relative);
            try {
                if (Files.getLastModifiedTime(fullPath, new LinkOption[0]).toMillis() > lastSyncMs && !Files.isDirectory(fullPath, new LinkOption[0])) {
                    this.requestUpload(projectId, (Path)fullPath, relative.toString());
                }
            }
            catch (IOException | JSONException e) {
                Logger.logError(e);
            }
        });
        String[] fileArray = (String[])fileList.stream().map(Path::toString).toArray(String[]::new);
        return fileArray;
    }

    public void requestProjectClear(CodewindApplication app, String[] fileList) throws JSONException, IOException {
        String clearEndpoint = "api/v1/projects/" + app.projectID + "/" + "remote-bind/clear";
        JSONObject payload = new JSONObject();
        payload.put("fileList", (Object)fileList);
        URI url = this.baseUri.resolve(clearEndpoint);
        HttpUtil.post(url, payload);
    }

    public void requestUpload(String projectId, Path fullPath, String relativePath) throws JSONException, IOException {
        byte[] fileContent = Files.readAllBytes(fullPath);
        String jsonContent = JSONObject.quote((String)new String(fileContent, "UTF-8"));
        Deflater fileDeflater = new Deflater();
        byte[] jsonBytes = jsonContent.getBytes("UTF-8");
        fileDeflater.setInput(jsonBytes);
        fileDeflater.finish();
        byte[] buffer = new byte[jsonBytes.length];
        ByteArrayOutputStream compressedStream = new ByteArrayOutputStream(jsonBytes.length);
        while (!fileDeflater.finished()) {
            int bytesCompressed = fileDeflater.deflate(buffer);
            compressedStream.write(buffer, 0, bytesCompressed);
        }
        Base64.Encoder encoder = Base64.getEncoder();
        String base64Compressed = encoder.encodeToString(compressedStream.toByteArray());
        JSONObject body = new JSONObject();
        body.put("directory", false);
        body.put("path", (Object)relativePath.replace('\\', '/'));
        body.put("msg", (Object)base64Compressed);
        String endpoint = "api/v1/projects/" + projectId + "/" + "remote-bind/upload";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.put(uri, body, 300);
        this.checkResult(result, uri, false);
    }

    public void requestProjectUnbind(String projectID) throws IOException {
        String endpoint = "api/v1/projects/" + projectID + "/" + "unbind";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    public List<ProjectTypeInfo> requestProjectTypes() throws IOException, JSONException {
        ArrayList<ProjectTypeInfo> projectTypes = new ArrayList<ProjectTypeInfo>();
        URI uri = this.baseUri.resolve("api/v1/project-types");
        HttpUtil.HttpResult result = HttpUtil.get(uri);
        this.checkResult(result, uri, true);
        JSONArray array = new JSONArray(result.response);
        for (int i = 0; i < array.length(); ++i) {
            projectTypes.add(new ProjectTypeInfo(array.getJSONObject(i)));
        }
        return projectTypes;
    }

    private void checkResult(HttpUtil.HttpResult result, URI uri, boolean checkContent) throws IOException {
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response code %d for uri %s with error message %s", result.responseCode, uri, result.error);
            throw new IOException(msg);
        }
        if (checkContent && result.response == null) {
            throw new IOException("Server returned good response code, but the content of the result is null for uri: " + uri);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConnectionError() {
        Logger.log("Connection to " + this.baseUri + " lost");
        this.isConnected = false;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.clear();
        }
        CoreUtil.updateAll();
    }

    public synchronized void clearConnectionError() {
        Logger.log("Connection to " + this.baseUri + " restored");
        try {
            String oldSocketNS = this.env.getSocketNamespace();
            this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri));
            if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
                Logger.logError("The detected version of Codewind after reconnect is not supported: " + this.env.getVersion());
                this.connectionErrorMsg = NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)InstallUtil.INSTALL_VERSION);
                CoreUtil.updateConnection(this);
                return;
            }
            String socketNS = this.env.getSocketNamespace();
            if (socketNS != null && !socketNS.equals(oldSocketNS) || oldSocketNS != null && !oldSocketNS.equals(socketNS)) {
                this.socket.close();
                this.socket = new CodewindSocket(this);
                if (!this.socket.blockUntilFirstConnection((IProgressMonitor)new NullProgressMonitor())) {
                    Logger.logError("Failed to create a new socket with updated URI: " + this.socket.socketUri);
                    this.connectionErrorMsg = null;
                    CoreUtil.updateAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.logError("An exception occurred while trying to update the connection information", e);
            this.connectionErrorMsg = Messages.Connection_ErrConnection_UpdateCacheException;
            CoreUtil.updateAll();
            return;
        }
        this.connectionErrorMsg = null;
        this.isConnected = true;
        this.refreshApps(null);
        CoreUtil.updateAll();
    }

    public String toString() {
        return String.format("%s @ name=%s baseUrl=%s", CodewindConnection.class.getSimpleName(), this.name, this.baseUri == null ? "unknown" : this.baseUri);
    }

    public void requestProjectDelete(String projectId) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + projectId;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri);
        this.checkResult(result, uri, false);
    }

    public URL getTektonDashboardURL() {
        return this.env.getTektonDashboardURL();
    }

    public URI getNewProjectURI() {
        return this.getProjectURI("new-project");
    }

    public URI getImportProjectURI() {
        return this.getProjectURI("import-project");
    }

    private URI getProjectURI(String projectQuery) {
        try {
            URI uri = this.baseUri;
            String query = projectQuery + "=" + "true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri;
        }
        catch (Exception e) {
            Logger.logError("Failed to get the project URI for the query: " + projectQuery, e);
            return null;
        }
    }

    public URL getAppMonitorURL(CodewindApplication app) {
        return this.getAppViewURL(app, "monitor");
    }

    public URL getAppViewURL(CodewindApplication app, String view) {
        try {
            URI uri = this.baseUri;
            String query = "project=" + app.projectID;
            query = query + "&" + "view" + "=" + view;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the URL for the " + view + " view and the " + app.name + "application.", e);
            return null;
        }
    }

    public URL getPerformanceMonitorURL(CodewindApplication app) {
        try {
            URI uri = this.baseUri;
            uri = uri.resolve("performance/charts");
            String query = "project=" + app.projectID;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the performance monitor URL for the " + app.name + "application.", e);
            return null;
        }
    }

    public boolean isLocal() {
        return false;
    }
}

