/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.IPlatformWatchService;
import org.eclipse.codewind.filewatchers.core.PathFilter;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;

public class EclipseResourceWatchService
implements IPlatformWatchService {
    private final Map<String, WatchedPath> projIdToWatchedPaths_synch = new HashMap<String, WatchedPath>();
    private final List<IPlatformWatchService.IPlatformWatchListener> listeners_synch = new ArrayList<IPlatformWatchService.IPlatformWatchListener>();
    private static final FWLogger log = FWLogger.getInstance();
    private final AtomicBoolean disposed_synch = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPlatformWatchService.IPlatformWatchListener gwl) {
        log.logDebug("Listener added to " + this.getClass().getSimpleName());
        List<IPlatformWatchService.IPlatformWatchListener> list = this.listeners_synch;
        synchronized (list) {
            this.listeners_synch.add(gwl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(File f, ProjectToWatch ptw) throws IOException {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
        }
        log.logInfo("Path '" + f.getPath() + "' added to " + this.getClass().getSimpleName());
        String key = ptw.getProjectId();
        Map<String, WatchedPath> map = this.projIdToWatchedPaths_synch;
        synchronized (map) {
            WatchedPath value = this.projIdToWatchedPaths_synch.get(key);
            if (value != null) {
                value.stopWatching();
            }
            this.projIdToWatchedPaths_synch.put(key, new WatchedPath(f, ptw, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(File f, ProjectToWatch ptw) {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
        }
        String key = ptw.getProjectId();
        Map<String, WatchedPath> map = this.projIdToWatchedPaths_synch;
        synchronized (map) {
            WatchedPath value = this.projIdToWatchedPaths_synch.remove(key);
            if (value != null) {
                log.logInfo("Path '" + f.getPath() + "' removed from " + this.getClass().getSimpleName());
                value.stopWatching();
            } else {
                log.logError("Path '" + f.getPath() + "' attempted to be removed, but could not be found, from" + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
            this.disposed_synch.set(true);
        }
        log.logInfo("dispose() called on " + this.getClass().getSimpleName());
        ArrayList<WatchedPath> toDispose = new ArrayList<WatchedPath>();
        Map<String, WatchedPath> map = this.projIdToWatchedPaths_synch;
        synchronized (map) {
            toDispose.addAll(this.projIdToWatchedPaths_synch.values());
            this.projIdToWatchedPaths_synch.clear();
        }
        toDispose.forEach(e -> FilewatcherUtils.newThread(() -> e.stopWatching()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveWatchEntries(String cwProjectId, List<WatchEventEntry> entries) {
        WatchedPath wp;
        Map<String, WatchedPath> map = this.projIdToWatchedPaths_synch;
        synchronized (map) {
            wp = this.projIdToWatchedPaths_synch.get(cwProjectId);
            if (wp == null) {
                System.err.println("Could not find project with ID '" + cwProjectId + "' in list.");
                return;
            }
        }
        wp.receiveFileChanges(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDebugState() {
        StringBuilder result = new StringBuilder();
        Map<String, WatchedPath> map = this.projIdToWatchedPaths_synch;
        synchronized (map) {
            this.projIdToWatchedPaths_synch.forEach((k, v) -> result.append("- " + k + " " + v.getPathRoot().getPath() + "\n"));
        }
        return result.toString();
    }

    private static class WatchedPath {
        private final PathFilter pathFilter;
        private final EclipseResourceWatchService parent;
        private final String pathInNormalizedForm;
        private final File pathRoot;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WatchedPath(File pathRoot, ProjectToWatch projectToWatch, EclipseResourceWatchService parent) throws IOException {
            this.pathInNormalizedForm = PathUtils.normalizePath((String)pathRoot.getPath());
            this.pathFilter = new PathFilter(projectToWatch);
            this.parent = parent;
            this.pathRoot = pathRoot;
            ArrayList listeners = new ArrayList();
            List list = parent.listeners_synch;
            synchronized (list) {
                listeners.addAll(parent.listeners_synch);
            }
            for (IPlatformWatchService.IPlatformWatchListener pw : listeners) {
                pw.watchAdded(projectToWatch, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveFileChanges(List<WatchEventEntry> entries) {
            ArrayList<WatchEventEntry> newEvents = new ArrayList<WatchEventEntry>();
            for (WatchEventEntry wee : entries) {
                String relativePath = PathUtils.convertAbsolutePathWithUnixSeparatorsToProjectRelativePath((String)wee.getAbsolutePathWithUnixSeparators(), (String)this.pathInNormalizedForm).orElse(null);
                if (WatchedPath.isFilteredOut(relativePath, this.pathFilter)) continue;
                newEvents.add(wee);
            }
            if (newEvents.size() > 0) {
                ArrayList listeners = new ArrayList();
                List list = this.parent.listeners_synch;
                synchronized (list) {
                    listeners.addAll(this.parent.listeners_synch);
                }
                for (IPlatformWatchService.IPlatformWatchListener gwl : listeners) {
                    gwl.changeDetected(newEvents);
                }
            }
        }

        private static boolean isFilteredOut(String relativePath, PathFilter pathFilter) {
            if (relativePath == null || relativePath.trim().length() <= 1) {
                return false;
            }
            if (pathFilter.isFilteredOutByFilename(relativePath)) {
                return true;
            }
            List pathsToProcess = PathUtils.splitRelativeProjectPathIntoComponentPaths((String)relativePath);
            for (String path : pathsToProcess) {
                if (!pathFilter.isFilteredOutByPath(path)) continue;
                return true;
            }
            return false;
        }

        public void stopWatching() {
        }

        public File getPathRoot() {
            return this.pathRoot;
        }
    }
}

