/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.net.ConnectException;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.internal.WebSocketManagerThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class JettyClientEndpoint {
    private static final FWLogger log = FWLogger.getInstance();
    private final WebSocketManagerThread parent;
    private final String wsUrl;

    public JettyClientEndpoint(WebSocketManagerThread parent, String wsUrl) {
        this.parent = parent;
        this.wsUrl = wsUrl;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        log.logInfo("WebSocket connection opened for " + this.wsUrl);
        if (this.parent != null) {
            this.parent.setSessionFromEndpoint(session);
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        log.logInfo("WebSocket connection closed with reason: " + statusCode + " " + reason + ", for url: " + this.wsUrl);
        if (this.parent != null) {
            this.parent.setSessionFromEndpoint(null);
            this.parent.queueEstablishConnection();
            this.parent.informConnectionFail();
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        if (this.parent != null) {
            this.parent.receiveMessage(msg);
        }
    }

    @OnWebSocketError
    public void onError(Throwable thr) {
        if (thr instanceof ConnectException && thr.getMessage().contains("Connection refused")) {
            log.logError("WebSocket onError throwable: " + thr + " for url: " + this.wsUrl);
        } else {
            log.logSevere("WebSocket onError throwable: " + thr + " for url: " + this.wsUrl);
            thr.printStackTrace();
        }
    }
}

