/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.ExceptionUtils;

public class UserDatabaseRealm
extends RealmBase {
    protected UserDatabase database = null;
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        GenericPrincipal gp;
        String realRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal instanceof GenericPrincipal && (gp = (GenericPrincipal)principal).getUserPrincipal() instanceof User) {
            principal = gp.getUserPrincipal();
        }
        if (!(principal instanceof User)) {
            return super.hasRole(null, principal, role);
        }
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        User user = (User)principal;
        Role dbrole = this.database.findRole(role);
        if (dbrole == null) {
            return false;
        }
        if (user.isInRole(dbrole)) {
            return true;
        }
        Iterator<Group> groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = groups.next();
            if (!group.isInRole(dbrole)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    @Override
    protected Principal getPrincipal(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        Iterator<Role> uroles = user.getRoles();
        while (uroles.hasNext()) {
            Role role = uroles.next();
            roles.add(role.getName());
        }
        Iterator<Group> groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = groups.next();
            uroles = group.getRoles();
            while (uroles.hasNext()) {
                Role role = uroles.next();
                roles.add(role.getName());
            }
        }
        return new GenericPrincipal(username, user.getPassword(), roles, user);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        try {
            Context context = this.getServer().getGlobalNamingContext();
            this.database = (UserDatabase)context.lookup(this.resourceName);
        }
        catch (Throwable e) {
            ExceptionUtils.handleThrowable((Throwable)e);
            this.containerLog.error((Object)sm.getString("userDatabaseRealm.lookup", new Object[]{this.resourceName}), e);
            this.database = null;
        }
        if (this.database == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", new Object[]{this.resourceName}));
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.database = null;
    }
}

