/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractNioInputBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNio2InputBuffer
extends AbstractNioInputBuffer<Nio2Channel> {
    private static final Log log = LogFactory.getLog(InternalNio2InputBuffer.class);
    private SocketWrapper<Nio2Channel> socket;
    protected volatile boolean interest = false;
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler;
    protected AbstractEndpoint<Nio2Channel> endpoint = null;
    protected volatile boolean readPending = false;
    protected IOException e = null;
    protected volatile boolean flipped = false;

    public InternalNio2InputBuffer(Request request, int headerBufferSize) {
        super(request, headerBufferSize);
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    @Override
    protected final Log getLog() {
        return log;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socket = null;
        this.readPending = false;
        this.flipped = false;
        this.interest = false;
        this.e = null;
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.interest = false;
    }

    public boolean isPending() {
        return this.readPending;
    }

    @Override
    protected void init(SocketWrapper<Nio2Channel> socketWrapper, AbstractEndpoint<Nio2Channel> associatedEndpoint) throws IOException {
        this.endpoint = associatedEndpoint;
        this.socket = socketWrapper;
        if (this.socket == null) {
            throw new IOException(sm.getString("iib.socketClosed"));
        }
        this.socketReadBufferSize = this.socket.getSocket().getBufHandler().getReadBuffer().capacity();
        int bufLength = this.headerBufferSize + this.socketReadBufferSize;
        if (this.buf == null || this.buf.length < bufLength) {
            this.buf = new byte[bufLength];
        }
        this.completionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
                boolean notify = false;
                CompletionHandler completionHandler = InternalNio2InputBuffer.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0) {
                        this.failed((Throwable)new EOFException(AbstractInputBuffer.sm.getString("iib.eof.error")), attachment);
                    } else {
                        InternalNio2InputBuffer.this.readPending = false;
                        if ((InternalNio2InputBuffer.this.request.getReadListener() == null || InternalNio2InputBuffer.this.interest) && !Nio2Endpoint.isInline()) {
                            InternalNio2InputBuffer.this.interest = false;
                            notify = true;
                        }
                    }
                }
                if (notify) {
                    InternalNio2InputBuffer.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, false);
                }
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                attachment.setError(true);
                InternalNio2InputBuffer.this.e = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                InternalNio2InputBuffer.this.request.setAttribute("javax.servlet.error.exception", InternalNio2InputBuffer.this.e);
                InternalNio2InputBuffer.this.readPending = false;
                InternalNio2InputBuffer.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fill(boolean block) throws IOException, EOFException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.parsingHeader) {
            if (this.lastValid > this.headerBufferSize) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
        int nRead = 0;
        ByteBuffer byteBuffer = this.socket.getSocket().getBufHandler().getReadBuffer();
        if (block) {
            int nBytes;
            if (!this.flipped) {
                byteBuffer.flip();
                this.flipped = true;
            }
            if ((nBytes = byteBuffer.remaining()) > 0) {
                this.expand(nBytes + this.pos);
                byteBuffer.get(this.buf, this.pos, nBytes);
                this.lastValid = this.pos + nBytes;
                byteBuffer.clear();
                this.flipped = false;
                return true;
            }
            byteBuffer.clear();
            this.flipped = false;
            Future<Integer> future = null;
            try {
                future = this.socket.getSocket().read(byteBuffer);
                nRead = future.get(this.socket.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                throw new SocketTimeoutException();
            }
            if (nRead > 0) {
                if (!this.flipped) {
                    byteBuffer.flip();
                    this.flipped = true;
                }
                this.expand(nRead + this.pos);
                byteBuffer.get(this.buf, this.pos, nRead);
                this.lastValid = this.pos + nRead;
                return true;
            }
            if (nRead == -1) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            return false;
        }
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            if (!this.readPending) {
                int nBytes;
                if (!this.flipped) {
                    byteBuffer.flip();
                    this.flipped = true;
                }
                if ((nBytes = byteBuffer.remaining()) > 0) {
                    this.expand(nBytes + this.pos);
                    byteBuffer.get(this.buf, this.pos, nBytes);
                    this.lastValid = this.pos + nBytes;
                    byteBuffer.clear();
                    this.flipped = false;
                } else {
                    byteBuffer.clear();
                    this.flipped = false;
                    this.readPending = true;
                    Nio2Endpoint.startInline();
                    this.socket.getSocket().read(byteBuffer, this.socket.getTimeout(), TimeUnit.MILLISECONDS, this.socket, this.completionHandler);
                    Nio2Endpoint.endInline();
                    if (!this.readPending) {
                        if (!this.flipped) {
                            byteBuffer.flip();
                            this.flipped = true;
                        }
                        if ((nBytes = byteBuffer.remaining()) > 0) {
                            this.expand(nBytes + this.pos);
                            byteBuffer.get(this.buf, this.pos, nBytes);
                            this.lastValid = this.pos + nBytes;
                        }
                        byteBuffer.clear();
                        this.flipped = false;
                    }
                }
                return this.lastValid - this.pos > 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReadInterest() {
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            if (this.readPending) {
                this.interest = true;
            } else {
                this.endpoint.processSocket(this.socket, SocketStatus.OPEN_READ, true);
            }
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNio2InputBuffer.this.pos >= InternalNio2InputBuffer.this.lastValid && !InternalNio2InputBuffer.this.fill(true)) {
                return -1;
            }
            if (InternalNio2InputBuffer.this.isBlocking()) {
                int length = InternalNio2InputBuffer.this.lastValid - InternalNio2InputBuffer.this.pos;
                chunk.setBytes(InternalNio2InputBuffer.this.buf, InternalNio2InputBuffer.this.pos, length);
                InternalNio2InputBuffer.this.pos = InternalNio2InputBuffer.this.lastValid;
                return length;
            }
            CompletionHandler completionHandler = InternalNio2InputBuffer.this.completionHandler;
            synchronized (completionHandler) {
                int length = InternalNio2InputBuffer.this.lastValid - InternalNio2InputBuffer.this.pos;
                chunk.setBytes(InternalNio2InputBuffer.this.buf, InternalNio2InputBuffer.this.pos, length);
                InternalNio2InputBuffer.this.pos = InternalNio2InputBuffer.this.lastValid;
                return length;
            }
        }
    }
}

