/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.debug;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugProvider;
import org.eclipse.cft.server.core.internal.debug.DebugProviderRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;

public class ApplicationDebugUILauncher
extends ApplicationDebugLauncher {
    public void launch(final CloudFoundryApplicationModule appModule, final CloudFoundryServer cloudServer, final int appInstance, final int remoteDebugPort) throws CoreException {
        final CloudFoundryDebugProvider provider = DebugProviderRegistry.getExistingProvider((CloudFoundryApplicationModule)appModule, (CloudFoundryServer)cloudServer);
        Job job = new Job("Launching debug - " + appModule.getDeployedApplicationName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ILaunchConfiguration launchConfiguration = provider.getLaunchConfiguration(appModule, cloudServer, appInstance, remoteDebugPort, monitor);
                    DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)"debug");
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)launchConfiguration.getType(), (String)"debug", (String)"org.eclipse.debug.ui.DebugPerspective");
                    ApplicationDebugUILauncher.fireDebugChanged((CloudFoundryServer)cloudServer, (CloudFoundryApplicationModule)appModule, (IStatus)Status.OK_STATUS);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (CoreException ce) {
                    CloudFoundryPlugin.getCallback().displayAndLogError(ce.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

