/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui;

import org.eclipse.cft.server.core.AbstractAppStateTracker;
import org.eclipse.cft.server.core.ICloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.console.ConsoleManagerRegistry;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractConsoleMonitorAppStateTracker
extends AbstractAppStateTracker {
    private ConsolePatternMatchListener consoleMonitor;

    protected ConsolePatternMatchListener createPatternMatchListener(ICloudFoundryApplicationModule appModule) {
        return new ConsolePatternMatchListener(appModule.getName());
    }

    protected MessageConsole findCloudFoundryConsole(IServer server, CloudFoundryApplicationModule appModule) {
        CloudFoundryServer cfServer = (CloudFoundryServer)server.getAdapter(CloudFoundryServer.class);
        return ConsoleManagerRegistry.getConsoleManager(cfServer).findCloudFoundryConsole(server, appModule);
    }

    public int getApplicationState(ICloudFoundryApplicationModule appModule) {
        if (Logger.DETAILS) {
            Logger.println("/debug/details", (Object)this, "getApplicationState", "Waiting for app to start: " + appModule.getName() + ", state=" + this.consoleMonitor.getApplicationState());
        }
        return this.consoleMonitor.getApplicationState();
    }

    protected abstract String getAppStartedPattern();

    public void startTracking(CloudFoundryApplicationModule appModule) {
        if (this.server == null || appModule == null) {
            return;
        }
        MessageConsole console = this.findCloudFoundryConsole(this.server, appModule);
        if (console != null) {
            if (Logger.INFO) {
                Logger.println("/debug/info", (Object)this, "isApplicationStarted", "Start app state tracking: " + appModule.getName());
            }
            this.consoleMonitor = this.createPatternMatchListener((ICloudFoundryApplicationModule)appModule);
            console.addPatternMatchListener((IPatternMatchListener)this.consoleMonitor);
        }
    }

    public void stopTracking(CloudFoundryApplicationModule appModule) {
        MessageConsole console;
        if (this.server == null || this.consoleMonitor == null || appModule == null) {
            return;
        }
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "stopTracking", "Stop app state tracking: " + appModule.getName());
        }
        if ((console = this.findCloudFoundryConsole(this.server, appModule)) != null) {
            console.removePatternMatchListener((IPatternMatchListener)this.consoleMonitor);
        }
    }

    public class ConsolePatternMatchListener
    implements IPatternMatchListener {
        private String appName;
        private int appState = 1;

        public ConsolePatternMatchListener(String curAppName) {
            this.appName = curAppName;
        }

        public void connect(TextConsole console) {
        }

        public synchronized void disconnect() {
        }

        public void matchFound(PatternMatchEvent event) {
            if (Logger.INFO) {
                Logger.println("/debug/info", this, "matchFound", "Application start detected: " + this.appName);
            }
            this.appState = 2;
        }

        public String getPattern() {
            return AbstractConsoleMonitorAppStateTracker.this.getAppStartedPattern();
        }

        public int getCompilerFlags() {
            return 2;
        }

        public String getLineQualifier() {
            return "\\n|\\r";
        }

        protected int getApplicationState() {
            return this.appState;
        }
    }
}

