/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.adapters;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ArtifactAdapter
implements IPropertySource {
    private static final String CATEGORY_NAME = "General";
    private final EObject artifact;
    private final ArtifactHelper artifactHelper;

    public ArtifactAdapter(EObject theItem) {
        this.artifact = theItem;
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        this.artifactHelper = new ArtifactHelper(artifactModel);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        if (!this.isArtifactWrapper(this.artifact)) {
            PropertyDescriptor labelDescriptor = new PropertyDescriptor((Object)DescriptorIDs.LABEL, "Label");
            labelDescriptor.setCategory(CATEGORY_NAME);
            propertyDescriptors.add(labelDescriptor);
            PropertyDescriptor locationDescriptor = new PropertyDescriptor((Object)DescriptorIDs.LOCATION, "Location");
            locationDescriptor.setCategory(CATEGORY_NAME);
            propertyDescriptors.add(locationDescriptor);
        }
        propertyDescriptors.addAll(this.artifact.eClass().getEAllAttributes().stream().map(attribute -> new TextPropertyDescriptor((Object)attribute.getName(), attribute.getName())).collect(Collectors.toList()));
        IPropertyDescriptor[] dummyList = new IPropertyDescriptor[propertyDescriptors.size()];
        return propertyDescriptors.toArray(dummyList);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals((Object)DescriptorIDs.LABEL)) {
            return this.artifactHelper.getArtifactLabel(this.artifact);
        }
        if (id.equals((Object)DescriptorIDs.LOCATION)) {
            return this.artifactHelper.getArtifactLocation(this.artifact);
        }
        EStructuralFeature a = this.artifact.eClass().getEStructuralFeature((String)id);
        return this.artifact.eGet(a);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        EStructuralFeature feature = this.artifact.eClass().getEStructuralFeature((String)id);
        this.artifact.eSet(feature, value);
    }

    private boolean isArtifactWrapper(EObject artifact) {
        return !artifact.equals(this.artifactHelper.unwrapWrapper((Object)artifact));
    }

    private static enum DescriptorIDs {
        LABEL,
        LOCATION;

    }
}

