/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filter;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.ValueFilter;
import org.eclipse.bpel.validator.rules.CPartnerActivityValidator;

public class OnEventValidator
extends CPartnerActivityValidator {
    protected INode fMyRoleNode;
    protected INode fVariable;
    protected INode fPortTypeFromRole;
    protected INode fAssociatedScope;
    protected String fCreateInstance;
    protected int fFromPartsCount;
    protected String fVariableName;
    private INode fVariableType;
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_EVENT_HANDLERS);
    static IFilter<QName> TYPE_DEFS = new ValueFilter<QName>(Filter.QNAME_COMPARATOR, AT_MESSAGE_TYPE, AT_ELEMENT);
    INode fInputMessage;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.fFromPartsCount = this.checkChild(ND_FROM_PARTS, 0, 1);
        this.checkChild(ND_SCOPE, 1, 1);
    }

    @Override
    protected void start() {
        super.start();
        this.fAssociatedScope = mSelector.selectNode(this.mNode, ND_SCOPE);
        this.setValue("associated.scope", this.fAssociatedScope);
    }

    @Override
    public void rule_CheckName_1() {
    }

    @Override
    public void rule_CheckSuppressJoinFailure_1() {
    }

    @Override
    @ARule(sa=84, desc="Partner Link resolution: associated scope first, then ancestor scopes", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC_MISSING_ROLE")
    public void rule_LookupPartnerLink_0() {
        INode context = this.fAssociatedScope;
        if (this.isUndefined(context)) {
            context = this.mNode;
        }
        this.fPartnerLinkNode = this.mModelQuery.lookup(context, 2, this.mNode.getAttribute(AT_PARTNER_LINK));
        this.markSAExecution(null);
    }

    @ARule(sa=90, desc="Either messageType or element must be specified if variable variant is used", date="3/15/2007", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE,BPELC__AT_LEAST_ONE,BPELC__AT_MOST_ONE,BPELC__SPECIFY_NONE")
    public void rule_LookupVariable_5() {
        this.fVariableName = this.getAttribute(this.mNode, AT_VARIABLE, 1, Filters.NC_NAME, false);
        String msgType = this.mNode.getAttribute(AT_MESSAGE_TYPE);
        String elmDecl = this.mNode.getAttribute(AT_ELEMENT);
        boolean bMsgTypeEmpty = OnEventValidator.isEmptyOrWhitespace(msgType);
        boolean bElmDeclEmpty = OnEventValidator.isEmptyOrWhitespace(elmDecl);
        if (!OnEventValidator.isEmpty(this.fVariableName)) {
            if (bElmDeclEmpty && bMsgTypeEmpty) {
                IProblem problem = this.createError();
                problem.fill("BPELC__AT_LEAST_ONE", this.toString(this.mNode.nodeName()), 1, TYPE_DEFS, 2);
                return;
            }
            if (!bElmDeclEmpty && !bMsgTypeEmpty) {
                IProblem problem = this.createError();
                problem.fill("BPELC__AT_MOST_ONE", this.toString(this.mNode.nodeName()), 1, TYPE_DEFS, 2);
            }
            if (!bElmDeclEmpty) {
                this.fVariableType = this.mModelQuery.lookup(this.mNode, 8, elmDecl);
                this.checkAttributeNode(this.mNode, this.fVariableType, AT_ELEMENT, 1);
            }
            if (!bMsgTypeEmpty) {
                this.fVariableType = this.mModelQuery.lookup(this.mNode, 7, msgType);
                this.checkAttributeNode(this.mNode, this.fVariableType, AT_MESSAGE_TYPE, 1);
            }
        } else if (!bMsgTypeEmpty || !bElmDeclEmpty) {
            IProblem problem = this.createError();
            problem.fill("BPELC__SPECIFY_NONE", this.toString(this.mNode.nodeName()), 0, TYPE_DEFS, 2);
        }
    }

    @ARule(sa=84, author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if my role is defined in onMessage activity.", errors="BPELC_MISSING_ROLE")
    public void rule_CheckIfMyRoleIsDefined_5() {
        this.fMyRoleNode = this.lookupRoleNode(this.fPartnerLinkNode, AT_MY_ROLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="03/13/2007", desc="Checks portType and derived portType values on onEvent.", sa=5, errors="BPELC_MISMATCH_ROLE_PORT_TYPE")
    public void rule_CheckRolePortTypeWithReceivePortType_10() {
        this.fPortTypeFromRole = this.verifyPortTypeFromRole(this.fMyRoleNode, AT_MY_ROLE, this.fPortType);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if input message is defined for onEvent activity.", errors="BPELC_PA__NO_MESSAGE,BPELC_PA__MSG_TYPE")
    public void rule_CheckInputMessage_12() {
        this.fInputMessage = this.findMessageType(this.fPortTypeFromRole, this.fOperation, WSDL_ND_INPUT, true);
        this.setValue("input.message.type", this.fInputMessage);
    }

    @ARule(sa=87, desc="Check message type compatability on onEvent", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC_PA__MESSAGE_TYPE_MISMATCH")
    public void rule_CheckVariableAndMessageStructureCompatibility_20() {
        if (this.isUndefined(this.fInputMessage) || this.isUndefined(this.fVariableType)) {
            return;
        }
        if (!this.mModelQuery.check(3, this.fVariableType, this.fInputMessage)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PA__MESSAGE_TYPE_MISMATCH", this.toString(this.mNode.nodeName()), AT_VARIABLE, this.fVariableName, this.fInputMessage, this.fVariableType);
        }
        this.markSAExecution(null);
    }

    @ARule(sa=85, desc="Check to see if fromPart is specified; if so then  variable must not be used onEvent.", author="michal.chmielewski@oracle.com", date="03/20/2007", errors="BPELC__PA_PARTS")
    public void rule_checkFromPartsPresence_50() {
        IProblem problem;
        List<INode> fFromParts = mSelector.selectNodes(this.mNode, ND_FROM_PARTS, ND_FROM_PART);
        boolean bNoVariable = OnEventValidator.isEmptyOrWhitespace(this.mNode.getAttribute(AT_VARIABLE));
        if (fFromParts.size() > 0 && !bNoVariable) {
            problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), ND_FROM_PART, AT_VARIABLE, 1);
        }
        if (fFromParts.size() == 0 && bNoVariable) {
            problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), ND_FROM_PART, AT_VARIABLE, 1);
        }
    }
}

