/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class ExtensionValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_EXTENSIONS);
    protected String fMustUnderstand;
    private String fNamespaceURI;

    @Override
    protected void start() {
        super.start();
    }

    @ARule(desc="Check mustUnderstand attribute.", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckMustUnderstand_1() {
        this.fMustUnderstand = this.getAttribute(this.mNode, AT_MUST_UNDERSTAND, 0, Filters.BOOLEAN_FILTER, true);
        if (this.fMustUnderstand == null) {
            this.fMustUnderstand = "no";
        }
    }

    @ARule(desc="Check namespaceURI attribute.", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckNamespaceURI_2() {
        this.fNamespaceURI = this.getAttribute(this.mNode, AT_NAMESPACE, 0, null, true);
    }

    @ARule(sa=9, desc="Mandatory extensions must be understood", date="03/15/2007", errors="BPELC_EXTENSION__NOT_SUPPORTED")
    public void rule_CheckMustUnderstand_20() {
        String key = "extension." + this.fNamespaceURI + "." + this.fMustUnderstand;
        if (this.containsValueKey(this.fParentNode, key)) {
            return;
        }
        boolean bSupports = this.mModelQuery.hasSupport(3, this.fNamespaceURI);
        this.setValue(this.fParentNode, key, bSupports);
        if (!bSupports && "yes".equals(this.fMustUnderstand)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_EXTENSION__NOT_SUPPORTED", this.toString(this.mNode.nodeName()), this.fNamespaceURI, this.fMustUnderstand);
        }
    }
}

