/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

public final class CompoundUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final Unit<Q> _high;
    private final Unit<Q> _low;
    private static final long serialVersionUID = 1L;

    CompoundUnit(Unit<Q> high, Unit<Q> low) {
        if (!high.getStandardUnit().equals(low.getStandardUnit())) {
            throw new IllegalArgumentException("Both units do not have the same system unit");
        }
        this._high = high;
        this._low = low;
    }

    public Unit<Q> getLower() {
        return this._low;
    }

    public Unit<Q> getHigher() {
        return this._high;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof CompoundUnit)) {
            return false;
        }
        CompoundUnit thatUnit = (CompoundUnit)that;
        return this._high.equals(thatUnit._high) && this._low.equals(thatUnit._low);
    }

    @Override
    public int hashCode() {
        return this._high.hashCode() ^ this._low.hashCode();
    }

    @Override
    public Unit<? super Q> getStandardUnit() {
        return this._low.getStandardUnit();
    }

    @Override
    public UnitConverter toStandardUnit() {
        return this._low.toStandardUnit();
    }
}

