/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math;

import java.util.List;
import javax.vecmath.GMatrix;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class GeometricUtils {
    public static Point3d lineTriangleIntersect(Point3d p0, Point3d p1, Point3d p2, Point3d rayOrigin, Vector3d rayDirection) {
        Point3d intersection = null;
        Vector3d e1 = new Vector3d((Tuple3d)p1);
        e1.sub((Tuple3d)p0);
        Vector3d e2 = new Vector3d((Tuple3d)p2);
        e2.sub((Tuple3d)p0);
        Vector3d p = new Vector3d();
        p.cross(rayDirection, e2);
        double tmp = p.dot(e1);
        double epsilon = 0.001;
        if (tmp > -epsilon && tmp < epsilon) {
            return null;
        }
        tmp = 1.0 / tmp;
        Vector3d s = new Vector3d((Tuple3d)rayOrigin);
        s.sub((Tuple3d)p0);
        double u = tmp * s.dot(p);
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        Vector3d q = new Vector3d();
        q.cross(s, e1);
        double v = tmp * rayDirection.dot(q);
        if (v < 0.0 || v > 1.0) {
            return null;
        }
        if (u + v > 1.0) {
            return null;
        }
        double t = tmp * e2.dot(q);
        intersection = new Point3d(rayOrigin);
        Vector3d part2 = new Vector3d(rayDirection);
        part2.scale(t);
        intersection.add((Tuple3d)part2);
        return intersection;
    }

    public static Vector3d extractRotationFromXYZRotMatrix(Matrix3d xyzRotationMatrix) {
        double r02 = xyzRotationMatrix.m02;
        double r12 = xyzRotationMatrix.m12;
        double r01 = xyzRotationMatrix.m01;
        double r00 = xyzRotationMatrix.m00;
        double r22 = xyzRotationMatrix.m22;
        double r10 = xyzRotationMatrix.m10;
        double r11 = xyzRotationMatrix.m11;
        double thetaY = Math.asin(r02);
        double thetaX = 0.0;
        double thetaZ = 0.0;
        double pidiv2 = 1.5707963267948966;
        if (thetaY < pidiv2) {
            if (thetaY > -pidiv2) {
                thetaX = Math.atan2(-r12, r22);
                thetaZ = Math.atan2(-r01, r00);
            } else {
                thetaX = -Math.atan2(r10, r11);
                thetaZ = 0.0;
            }
        } else {
            thetaX = Math.atan2(r10, r11);
            thetaZ = 0.0;
        }
        return new Vector3d(thetaX, thetaY, thetaZ);
    }

    public static Vector3d extractRotationFromZYXRotMatrix(Matrix3d yprRotationMatrix) {
        double thetaX;
        double thetaZ;
        double pidiv2;
        double r20 = yprRotationMatrix.m20;
        double r10 = yprRotationMatrix.m10;
        double r00 = yprRotationMatrix.m00;
        double r21 = yprRotationMatrix.m21;
        double r22 = yprRotationMatrix.m22;
        double r01 = yprRotationMatrix.m01;
        double r02 = yprRotationMatrix.m02;
        double thetaY = Math.asin(-r20);
        if (thetaY < (pidiv2 = 1.5707963267948966)) {
            if (thetaY > -pidiv2) {
                thetaZ = Math.atan2(r10, r00);
                thetaX = Math.atan2(r21, r22);
            } else {
                thetaZ = Math.atan2(-r01, -r02);
                thetaX = 0.0;
            }
        } else {
            thetaZ = -Math.atan2(r01, r02);
            thetaX = 0.0;
        }
        return new Vector3d(thetaX, thetaY, thetaZ);
    }

    public static Vector3d extractRotationFromYZXRotMatrix(Matrix3d yzxRotationMatrix) {
        double thetaX;
        double thetaY;
        double pidiv2;
        double r12 = yzxRotationMatrix.m12;
        double r10 = yzxRotationMatrix.m10;
        double r20 = yzxRotationMatrix.m20;
        double r21 = yzxRotationMatrix.m21;
        double r00 = yzxRotationMatrix.m00;
        double r11 = yzxRotationMatrix.m11;
        double r22 = yzxRotationMatrix.m22;
        double thetaZ = Math.asin(r10);
        if (thetaZ < (pidiv2 = 1.5707963267948966)) {
            if (thetaZ > -pidiv2) {
                thetaY = Math.atan2(-r20, r00);
                thetaX = Math.atan2(-r12, r11);
            } else {
                thetaY = -Math.atan2(r21, r22);
                thetaX = 0.0;
            }
        } else {
            thetaY = Math.atan2(r21, r22);
            thetaX = 0.0;
        }
        return new Vector3d(thetaX, thetaY, thetaZ);
    }

    public static Matrix4d packZYX(double tx, double ty, double tz, double rx, double ry, double rz) {
        Matrix3d rMatx = new Matrix3d();
        rMatx.rotX(rx);
        Matrix3d rMaty = new Matrix3d();
        rMaty.rotY(ry);
        Matrix3d rMatz = new Matrix3d();
        rMatz.rotZ(rz);
        rMatz.mul(rMaty);
        rMatz.mul(rMatx);
        Matrix4d trMatrix = new Matrix4d(rMatz, new Vector3d(tx, ty, tz), 1.0);
        return trMatrix;
    }

    public static Matrix3d packXYZ(double rx, double ry, double rz) {
        Matrix3d rMatx = new Matrix3d();
        rMatx.rotX(rx);
        Matrix3d rMaty = new Matrix3d();
        rMaty.rotY(ry);
        Matrix3d rMatz = new Matrix3d();
        rMatz.rotZ(rz);
        rMatx.mul(rMaty);
        rMatx.mul(rMatz);
        return rMatx;
    }

    public static Matrix3d packYZX(double rx, double ry, double rz) {
        Matrix3d rMatx = new Matrix3d();
        rMatx.rotX(rx);
        Matrix3d rMaty = new Matrix3d();
        rMaty.rotY(ry);
        Matrix3d rMatz = new Matrix3d();
        rMatz.rotZ(rz);
        rMaty.mul(rMatz);
        rMaty.mul(rMatx);
        return rMaty;
    }

    public static Matrix3d packYXZ(double rx, double ry, double rz) {
        Matrix3d rMatz = new Matrix3d();
        rMatz.rotZ(rz);
        Matrix3d rMaty = new Matrix3d();
        rMaty.rotY(ry);
        Matrix3d rMatx = new Matrix3d();
        rMatx.rotX(rx);
        rMaty.mul(rMatx);
        rMaty.mul(rMatz);
        return rMaty;
    }

    public static Matrix4d packXYZ(double tx, double ty, double tz, double rx, double ry, double rz) {
        Matrix4d trMatrix = new Matrix4d(GeometricUtils.packXYZ(rx, ry, rz), new Vector3d(tx, ty, tz), 1.0);
        return trMatrix;
    }

    public static Matrix4d packYZX(double tx, double ty, double tz, double rx, double ry, double rz) {
        Matrix4d trMatrix = new Matrix4d(GeometricUtils.packYZX(rx, ry, rz), new Vector3d(tx, ty, tz), 1.0);
        return trMatrix;
    }

    public static Matrix4d invertTransformationMatrix(Matrix4d matrix) {
        Matrix3d rotation_matrix = new Matrix3d();
        Vector3d translation_vector = new Vector3d();
        matrix.get(rotation_matrix, translation_vector);
        rotation_matrix.transpose();
        Vector3d row0 = new Vector3d();
        Vector3d row1 = new Vector3d();
        Vector3d row2 = new Vector3d();
        Matrix3d minus_rotation_matrix_transposed = new Matrix3d();
        minus_rotation_matrix_transposed.mul(-1.0, rotation_matrix);
        minus_rotation_matrix_transposed.getRow(0, row0);
        minus_rotation_matrix_transposed.getRow(1, row1);
        minus_rotation_matrix_transposed.getRow(2, row2);
        Vector3d reverse_translation_vector = new Vector3d(row0.dot(translation_vector), row1.dot(translation_vector), row2.dot(translation_vector));
        Matrix4d reverse_matrix = new Matrix4d(rotation_matrix, reverse_translation_vector, 1.0);
        return reverse_matrix;
    }

    public static Matrix3d packZYX(double rx, double ry, double rz) {
        Matrix3d rMatx = new Matrix3d();
        rMatx.rotX(rx);
        Matrix3d rMaty = new Matrix3d();
        rMaty.rotY(ry);
        Matrix3d rMatz = new Matrix3d();
        rMatz.rotZ(rz);
        rMaty.mul(rMatx);
        rMatz.mul(rMaty);
        return rMatz;
    }

    public static void outerProduct(Vector3d v1, Vector3d v2, GMatrix res) {
        double[] a = new double[3];
        double[] b = new double[3];
        v1.get(a);
        v2.get(b);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                res.setElement(i, j, a[i] * b[j]);
                ++j;
            }
            ++i;
        }
    }

    public static Matrix4d computeMatrix(List<Matrix4d> matrices, boolean reverse) {
        Matrix4d result = new Matrix4d();
        result.setIdentity();
        while (!matrices.isEmpty()) {
            Matrix4d matrix = null;
            matrix = reverse ? matrices.remove(matrices.size() - 1) : matrices.remove(0);
            result.mul(matrix);
        }
        return result;
    }

    public static Vector3d computeOrientationDifference(Vector3d v0, Vector3d v1) {
        double ox = GeometricUtils.computeAngularDifference(v0.x, v1.x);
        double oy = GeometricUtils.computeAngularDifference(v0.y, v1.y);
        double oz = GeometricUtils.computeAngularDifference(v0.z, v1.z);
        Vector3d result = new Vector3d(ox, oy, oz);
        return result;
    }

    public static double computeAngularDifference(double angle0, double angle1) {
        double newAngle0 = GeometricUtils.normalizeAngle(angle0);
        double newAngle1 = GeometricUtils.normalizeAngle(angle1);
        return GeometricUtils.normalizeAngle(newAngle0 - newAngle1);
    }

    public static double normalizeAngle(double angle) {
        double result = angle;
        if (angle > Math.PI * 2 || angle < Math.PI * -2) {
            result = Math.IEEEremainder(angle, Math.PI * 2);
        }
        if (result > Math.PI) {
            result -= Math.PI * 2;
        } else if (result < -Math.PI) {
            result += Math.PI * 2;
        }
        return result;
    }

    public static double normalizeAngleToPositiveValue(double angle) {
        double result = 0.0;
        if (angle >= 0.0 && angle <= Math.PI * 2) {
            result = angle;
        } else if (angle > Math.PI * 2) {
            result = Math.IEEEremainder(angle, Math.PI * 2);
        } else if (angle < 0.0 && (result = GeometricUtils.normalizeAngle(angle)) < 0.0) {
            result += Math.PI * 2;
        }
        return result;
    }

    public static double pointToTriangleDistanceSquared(Point3d p, Point3d v0, Point3d v1, Point3d v2, Point3d q) {
        double fTmp0;
        double fTmp1;
        double fSqrDistance;
        Vector3d kDiff = new Vector3d((Tuple3d)v0);
        kDiff.sub((Tuple3d)p);
        Vector3d kEdge0 = new Vector3d((Tuple3d)v1);
        kEdge0.sub((Tuple3d)v0);
        Vector3d kEdge1 = new Vector3d((Tuple3d)v2);
        kEdge1.sub((Tuple3d)v0);
        double fA00 = kEdge0.lengthSquared();
        double fA01 = kEdge0.dot(kEdge1);
        double fA11 = kEdge1.lengthSquared();
        double fB0 = kDiff.dot(kEdge0);
        double fB1 = kDiff.dot(kEdge1);
        double fC = kDiff.lengthSquared();
        double fDet = Math.abs(fA00 * fA11 - fA01 * fA01);
        double fS = fA01 * fB1 - fA11 * fB0;
        double fT = fA01 * fB0 - fA00 * fB1;
        if (fS + fT <= fDet) {
            if (fS < 0.0) {
                if (fT < 0.0) {
                    if (fB0 < 0.0) {
                        fT = 0.0;
                        if (-fB0 >= fA00) {
                            fS = 1.0;
                            fSqrDistance = fA00 + 2.0 * fB0 + fC;
                        } else {
                            fS = -fB0 / fA00;
                            fSqrDistance = fB0 * fS + fC;
                        }
                    } else {
                        fS = 0.0;
                        if (fB1 >= 0.0) {
                            fT = 0.0;
                            fSqrDistance = fC;
                        } else if (-fB1 >= fA11) {
                            fT = 1.0;
                            fSqrDistance = fA11 + 2.0 * fB1 + fC;
                        } else {
                            fT = -fB1 / fA11;
                            fSqrDistance = fB1 * fT + fC;
                        }
                    }
                } else {
                    fS = 0.0;
                    if (fB1 >= 0.0) {
                        fT = 0.0;
                        fSqrDistance = fC;
                    } else if (-fB1 >= fA11) {
                        fT = 1.0;
                        fSqrDistance = fA11 + 2.0 * fB1 + fC;
                    } else {
                        fT = -fB1 / fA11;
                        fSqrDistance = fB1 * fT + fC;
                    }
                }
            } else if (fT < 0.0) {
                fT = 0.0;
                if (fB0 >= 0.0) {
                    fS = 0.0;
                    fSqrDistance = fC;
                } else if (-fB0 >= fA00) {
                    fS = 1.0;
                    fSqrDistance = fA00 + 2.0 * fB0 + fC;
                } else {
                    fS = -fB0 / fA00;
                    fSqrDistance = fB0 * fS + fC;
                }
            } else {
                double fInvDet = 1.0 / fDet;
                fSqrDistance = (fS *= fInvDet) * (fA00 * fS + fA01 * (fT *= fInvDet) + 2.0 * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0 * fB1) + fC;
            }
        } else if (fS < 0.0) {
            fTmp1 = fA11 + fB1;
            fTmp0 = fA01 + fB0;
            if (fTmp1 > fTmp0) {
                double fNumer = fTmp1 - fTmp0;
                double fDenom = fA00 - 2.0 * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fS = 1.0;
                    fT = 0.0;
                    fSqrDistance = fA00 + 2.0 * fB0 + fC;
                } else {
                    fS = fNumer / fDenom;
                    fT = 1.0 - fS;
                    fSqrDistance = fS * (fA00 * fS + fA01 * fT + 2.0 * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0 * fB1) + fC;
                }
            } else {
                fS = 0.0;
                if (fTmp1 <= 0.0) {
                    fT = 1.0;
                    fSqrDistance = fA11 + 2.0 * fB1 + fC;
                } else if (fB1 >= 0.0) {
                    fT = 0.0;
                    fSqrDistance = fC;
                } else {
                    fT = -fB1 / fA11;
                    fSqrDistance = fB1 * fT + fC;
                }
            }
        } else if (fT < 0.0) {
            fTmp1 = fA00 + fB0;
            fTmp0 = fA01 + fB1;
            if (fTmp1 > fTmp0) {
                double fNumer = fTmp1 - fTmp0;
                double fDenom = fA00 - 2.0 * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fT = 1.0;
                    fS = 0.0;
                    fSqrDistance = fA11 + 2.0 * fB1 + fC;
                } else {
                    fT = fNumer / fDenom;
                    fS = 1.0 - fT;
                    fSqrDistance = fS * (fA00 * fS + fA01 * fT + 2.0 * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0 * fB1) + fC;
                }
            } else {
                fT = 0.0;
                if (fTmp1 <= 0.0) {
                    fS = 1.0;
                    fSqrDistance = fA00 + 2.0 * fB0 + fC;
                } else if (fB0 >= 0.0) {
                    fS = 0.0;
                    fSqrDistance = fC;
                } else {
                    fS = -fB0 / fA00;
                    fSqrDistance = fB0 * fS + fC;
                }
            }
        } else {
            double fNumer = fA11 + fB1 - fA01 - fB0;
            if (fNumer <= 0.0) {
                fS = 0.0;
                fT = 1.0;
                fSqrDistance = fA11 + 2.0 * fB1 + fC;
            } else {
                double fDenom = fA00 - 2.0 * fA01 + fA11;
                if (fNumer >= fDenom) {
                    fS = 1.0;
                    fT = 0.0;
                    fSqrDistance = fA00 + 2.0 * fB0 + fC;
                } else {
                    fS = fNumer / fDenom;
                    fT = 1.0 - fS;
                    fSqrDistance = fS * (fA00 * fS + fA01 * fT + 2.0 * fB0) + fT * (fA01 * fS + fA11 * fT + 2.0 * fB1) + fC;
                }
            }
        }
        if (fSqrDistance < 0.0) {
            fSqrDistance = 0.0;
        }
        Point3d B = new Point3d(v0);
        Vector3d ve0 = new Vector3d(kEdge0);
        Vector3d ve1 = new Vector3d(kEdge1);
        ve0.scale(fS);
        ve1.scale(fT);
        B.add((Tuple3d)ve0);
        B.add((Tuple3d)ve1);
        q.set((Tuple3d)B);
        return fSqrDistance;
    }
}

