/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesMesh;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.DigitalElevationMap;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.NormalPointCloud;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.geometry.data3d.RGBAColor;
import org.eclipse.apogy.common.geometry.data3d.SphericalCoordinates;
import org.eclipse.apogy.common.geometry.data3d.impl.ApogyCommonGeometryData3DFacadeImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonGeometryData3DFacadeCustomImpl
extends ApogyCommonGeometryData3DFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonGeometryData3DFacadeImpl.class);

    @Override
    public CartesianPositionCoordinates createCartesianPositionCoordinates(double x, double y, double z) {
        CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        coord.setX(x);
        coord.setY(y);
        coord.setZ(z);
        return coord;
    }

    @Override
    public ColoredCartesianPositionCoordinates createColoredCartesianPositionCoordinates(double x, double y, double z, short red, short green, short blue) {
        return this.createColoredCartesianPositionCoordinates(x, y, z, (short)255, red, green, blue);
    }

    @Override
    public ColoredCartesianPositionCoordinates createColoredCartesianPositionCoordinates(double x, double y, double z, short alpha, short red, short green, short blue) {
        ColoredCartesianPositionCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createColoredCartesianPositionCoordinates();
        coord.setX(x);
        coord.setY(y);
        coord.setZ(z);
        coord.setAlpha(alpha);
        coord.setRed(red);
        coord.setGreen(green);
        coord.setBlue(blue);
        return coord;
    }

    @Override
    public CartesianOrientationCoordinates createCartesianOrientationCoordinates(double xRotation, double yRotation, double zRotation) {
        CartesianOrientationCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianOrientationCoordinates();
        coord.setXRotation(xRotation);
        coord.setYRotation(yRotation);
        coord.setZRotation(zRotation);
        return coord;
    }

    @Override
    public SphericalCoordinates createSphericalCoordinates(double phi, double theta, double r) {
        SphericalCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createSphericalCoordinates();
        coord.setPhi(phi);
        coord.setTheta(theta);
        coord.setR(r);
        return coord;
    }

    @Override
    public Pose createPose(double x, double y, double z, double xRotation, double yRotation, double zRotation) {
        Pose pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
        pose.setX(x);
        pose.setY(y);
        pose.setZ(z);
        pose.setXRotation(xRotation);
        pose.setYRotation(yRotation);
        pose.setZRotation(zRotation);
        return pose;
    }

    @Override
    public Pose createPose(Pose pose) {
        return this.createPose(pose.getX(), pose.getY(), pose.getZ(), pose.getXRotation(), pose.getYRotation(), pose.getZRotation());
    }

    @Override
    public Pose createPose(CartesianPositionCoordinates position, CartesianOrientationCoordinates orientation) {
        Pose pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
        pose.setX(position.getX());
        pose.setY(position.getY());
        pose.setZ(position.getZ());
        pose.setXRotation(orientation.getXRotation());
        pose.setYRotation(orientation.getYRotation());
        pose.setZRotation(orientation.getZRotation());
        return pose;
    }

    @Override
    public CartesianPolygon createCartesianPolygon(CartesianPositionCoordinates v1, CartesianPositionCoordinates v2, CartesianPositionCoordinates v3) {
        CartesianPolygon polygon = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
        polygon.getVertices().add((Object)v1);
        polygon.getVertices().add((Object)v2);
        polygon.getVertices().add((Object)v3);
        return polygon;
    }

    @Override
    public CartesianPositionCoordinates createCartesianPositionCoordinates(CartesianPositionCoordinates coordinates) {
        CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates();
        coord.setX(coordinates.getX());
        coord.setY(coordinates.getY());
        coord.setZ(coordinates.getZ());
        return coord;
    }

    @Override
    public CartesianOrientationCoordinates createCartesianOrientationCoordinates(CartesianOrientationCoordinates coordinates) {
        CartesianOrientationCoordinates coord = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianOrientationCoordinates();
        coord.setXRotation(coordinates.getXRotation());
        coord.setYRotation(coordinates.getYRotation());
        coord.setZRotation(coordinates.getZRotation());
        return coord;
    }

    @Override
    public CartesianCoordinatesMesh createCartesianCoordinatesMesh(CartesianCoordinatesMesh cartesianCoordinatesMesh) {
        return (CartesianCoordinatesMesh)EcoreUtil.copy((EObject)cartesianCoordinatesMesh);
    }

    @Override
    public CartesianTriangle createCartesianTriangle(CartesianPositionCoordinates v1, CartesianPositionCoordinates v2, CartesianPositionCoordinates v3) {
        CartesianTriangle triangle = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
        triangle.getVertices().add((Object)v1);
        triangle.getVertices().add((Object)v2);
        triangle.getVertices().add((Object)v3);
        return triangle;
    }

    @Override
    public <T extends CartesianPolygon> CartesianTriangle createCartesianTriangle(T polygon) throws IllegalArgumentException {
        CartesianTriangle triangle = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
        if (polygon.getVertices().size() != 3) {
            throw new IllegalArgumentException();
        }
        triangle.getVertices().addAll((Collection)polygon.getVertices());
        return triangle;
    }

    @Override
    public CartesianCoordinatesSet applyTransform(CartesianCoordinatesSet points, Matrix4d trMatrix) {
        CartesianCoordinatesSet trPoints = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        ArrayList<CartesianPositionCoordinates> pointList = new ArrayList<CartesianPositionCoordinates>();
        for (CartesianPositionCoordinates point : points.getPoints()) {
            Point3d p = point.asPoint3d();
            trMatrix.transform(p);
            CartesianPositionCoordinates trPoint = this.createCartesianPositionCoordinates(p.x, p.y, p.z);
            pointList.add(trPoint);
        }
        trPoints.getPoints().addAll(pointList);
        return trPoints;
    }

    @Override
    public CartesianCoordinatesMesh createCartesianCoordinatesMesh(List<CartesianPolygon> polygons) {
        CartesianCoordinatesMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesMesh();
        TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopyMap = new TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates>(new Geometry3DUtilities.CartesianPositionCoordinatesDistanceComparator());
        for (CartesianPolygon polygon : polygons) {
            CartesianPolygon polygonCopy = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
            mesh.getPolygons().add((Object)polygonCopy);
            for (CartesianPositionCoordinates point : polygon.getVertices()) {
                CartesianPositionCoordinates pointCopy = (CartesianPositionCoordinates)originalToCopyMap.get(point);
                if (pointCopy == null) {
                    pointCopy = this.createCartesianPositionCoordinates(point);
                    mesh.getPoints().add((Object)pointCopy);
                    originalToCopyMap.put(point, pointCopy);
                }
                polygonCopy.getVertices().add((Object)pointCopy);
            }
        }
        return mesh;
    }

    @Override
    public CartesianTriangularMesh createCartesianTriangularMesh(List<CartesianTriangle> polygons) {
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopyMap = new TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates>(new Geometry3DUtilities.CartesianPositionCoordinatesDistanceComparator());
        for (CartesianPolygon cartesianPolygon : polygons) {
            CartesianTriangle polygonCopy = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
            mesh.getPolygons().add((Object)polygonCopy);
            for (CartesianPositionCoordinates point : cartesianPolygon.getVertices()) {
                CartesianPositionCoordinates pointCopy = (CartesianPositionCoordinates)originalToCopyMap.get(point);
                if (pointCopy == null) {
                    pointCopy = this.createCartesianPositionCoordinates(point);
                    mesh.getPoints().add((Object)pointCopy);
                    originalToCopyMap.put(point, pointCopy);
                }
                polygonCopy.getVertices().add((Object)pointCopy);
            }
        }
        return mesh;
    }

    @Override
    public List<CartesianPositionCoordinates> applyTransform(List<CartesianPositionCoordinates> points, Matrix4d trMatrix) {
        ArrayList<CartesianPositionCoordinates> trPoints = new ArrayList<CartesianPositionCoordinates>(points.size());
        for (CartesianPositionCoordinates point : points) {
            Point3d p = point.asPoint3d();
            trMatrix.transform(p);
            CartesianPositionCoordinates trPoint = this.createCartesianPositionCoordinates(p.x, p.y, p.z);
            trPoints.add(trPoint);
        }
        return trPoints;
    }

    @Override
    public CartesianTriangularMesh createTransformedMesh(CartesianTriangularMesh mesh, Matrix4d trMatrix) {
        ArrayList<CartesianPositionCoordinates> trPoints = new ArrayList<CartesianPositionCoordinates>();
        HashMap<CartesianPositionCoordinates, Integer> pointToIdMap = new HashMap<CartesianPositionCoordinates, Integer>();
        int i = 0;
        for (CartesianPositionCoordinates p : mesh.getPoints()) {
            Point3d p3d = p.asPoint3d();
            trMatrix.transform(p3d);
            CartesianPositionCoordinates trP = this.createCartesianPositionCoordinates(p3d.x, p3d.y, p3d.z);
            trPoints.add(trP);
            pointToIdMap.put(p, i++);
        }
        ArrayList<CartesianTriangle> triangles = new ArrayList<CartesianTriangle>();
        for (CartesianTriangle tri : mesh.getPolygons()) {
            CartesianTriangle newTri = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
            for (CartesianPositionCoordinates triPoint : tri.getVertices()) {
                int id = (Integer)pointToIdMap.get(triPoint);
                CartesianPositionCoordinates newPoint = (CartesianPositionCoordinates)trPoints.get(id);
                newTri.getVertices().add((Object)newPoint);
            }
            triangles.add(newTri);
        }
        CartesianTriangularMesh trMesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        trMesh.getPoints().addAll(trPoints);
        trMesh.getPolygons().addAll(triangles);
        if (mesh.getNormals() != null) {
            LinkedList<Vector3d> trNormals = new LinkedList<Vector3d>();
            Matrix3d rotation = new Matrix3d();
            trMatrix.getRotationScale(rotation);
            rotation.setScale(1.0);
            for (Vector3d normal : mesh.getNormals()) {
                Vector3d trNormal = new Vector3d(normal);
                rotation.transform((Tuple3d)trNormal);
                trNormals.add(trNormal);
            }
            trMesh.setNormals(trNormals);
        }
        return trMesh;
    }

    @Override
    public void applyTransform(CartesianTriangularMesh mesh, Matrix4d trMatrix) {
        for (CartesianPositionCoordinates p : mesh.getPoints()) {
            Point3d p3d = p.asPoint3d();
            trMatrix.transform(p3d);
            p.setX(p3d.x);
            p.setY(p3d.y);
            p.setZ(p3d.z);
        }
    }

    @Override
    public NormalPointCloud applyTransform(NormalPointCloud points, Matrix4d trMatrix) {
        if (points.getNormals() != null && points.getNormals().size() != points.getPoints().size()) {
            throw new IllegalArgumentException("Error: normal (" + points.getNormals().size() + ") != points (" + points.getPoints().size() + ")");
        }
        Matrix3d rotation = new Matrix3d();
        trMatrix.getRotationScale(rotation);
        rotation.setScale(1.0);
        ArrayList<Vector3d> trNormals = null;
        if (points.getNormals() != null) {
            trNormals = new ArrayList<Vector3d>(points.getNormals().size());
        }
        ArrayList<Point3d> trPoints = new ArrayList<Point3d>(points.getPoints().size());
        int i = 0;
        while (i < points.getPoints().size()) {
            Point3d pi = new Point3d(points.getPoints().get(i));
            if (points.getNormals() != null) {
                Vector3d ni = new Vector3d(points.getNormals().get(i));
                rotation.transform((Tuple3d)ni);
                trNormals.add(ni);
            }
            trMatrix.transform(pi);
            trPoints.add(pi);
            ++i;
        }
        NormalPointCloud trPointCloud = ApogyCommonGeometryData3DFactory.eINSTANCE.createNormalPointCloud();
        trPointCloud.setNormals(trNormals);
        trPointCloud.setPoints(trPoints);
        return trPointCloud;
    }

    @Override
    public CartesianCoordinatesMesh createCartesianCoordinatesMesh(CartesianTriangularMesh cartesianTriangularMesh) {
        CartesianCoordinatesMesh ccmesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesMesh();
        TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopyMap = new TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates>(new Geometry3DUtilities.CartesianPositionCoordinatesDistanceComparator());
        for (CartesianTriangle polygon : cartesianTriangularMesh.getPolygons()) {
            CartesianPolygon polygonCopy = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPolygon();
            ccmesh.getPolygons().add((Object)polygonCopy);
            for (CartesianPositionCoordinates point : polygon.getVertices()) {
                CartesianPositionCoordinates pointCopy = (CartesianPositionCoordinates)originalToCopyMap.get(point);
                if (pointCopy == null) {
                    pointCopy = this.createCartesianPositionCoordinates(point);
                    ccmesh.getPoints().add((Object)pointCopy);
                    originalToCopyMap.put(point, pointCopy);
                }
                polygonCopy.getVertices().add((Object)pointCopy);
            }
        }
        return ccmesh;
    }

    @Override
    public CartesianTriangularMesh createCartesianTriangularMesh(CartesianTriangularMesh cartesianTriangularMesh) {
        CartesianTriangularMesh trimesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopyMap = new TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates>(new Geometry3DUtilities.CartesianPositionCoordinatesDistanceComparator());
        for (CartesianPositionCoordinates point : cartesianTriangularMesh.getPoints()) {
            CartesianPositionCoordinates pointCopy = this.createCartesianPositionCoordinates(point);
            trimesh.getPoints().add((Object)pointCopy);
            originalToCopyMap.put(point, pointCopy);
        }
        for (CartesianPolygon polygon : cartesianTriangularMesh.getPolygons()) {
            CartesianTriangle polygonCopy = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
            for (CartesianPositionCoordinates point : polygon.getVertices()) {
                CartesianPositionCoordinates pointCopy = (CartesianPositionCoordinates)originalToCopyMap.get(point);
                polygonCopy.getVertices().add((Object)pointCopy);
            }
            if (polygonCopy.getVertices().size() != 3) continue;
            trimesh.getPolygons().add((Object)polygonCopy);
        }
        return trimesh;
    }

    @Override
    public void updateCartesianCoordinatesSet(CartesianCoordinatesSet cartesianCoordinatesSet, double[][] xyzData) {
        int j;
        int numberOfPointsInSet = cartesianCoordinatesSet.getPoints().size();
        if (xyzData.length > numberOfPointsInSet) {
            ArrayList<CartesianPositionCoordinates> toAdd = new ArrayList<CartesianPositionCoordinates>();
            j = numberOfPointsInSet;
            while (j < xyzData.length) {
                toAdd.add(this.createCartesianPositionCoordinates(xyzData[j][0], xyzData[j][1], xyzData[j][2]));
                ++j;
            }
            cartesianCoordinatesSet.getPoints().addAll(toAdd);
        } else {
            ArrayList<CartesianPositionCoordinates> toRemove = new ArrayList<CartesianPositionCoordinates>();
            j = xyzData.length;
            while (j < numberOfPointsInSet) {
                toRemove.add((CartesianPositionCoordinates)cartesianCoordinatesSet.getPoints().get(j));
                ++j;
            }
            cartesianCoordinatesSet.getPoints().removeAll(toRemove);
        }
        int numberOfPointsInArray = xyzData.length;
        int i = 0;
        while (i < numberOfPointsInArray) {
            ((CartesianPositionCoordinates)cartesianCoordinatesSet.getPoints().get(i)).setX(xyzData[i][0]);
            ((CartesianPositionCoordinates)cartesianCoordinatesSet.getPoints().get(i)).setY(xyzData[i][1]);
            ((CartesianPositionCoordinates)cartesianCoordinatesSet.getPoints().get(i)).setZ(xyzData[i][2]);
            ++i;
        }
    }

    @Override
    public DigitalElevationMap createDigitalElevationMap(CartesianCoordinatesSet coordinatesSet) {
        TreeMap<Double, TreeSet<CartesianPositionCoordinates>> map = new TreeMap<Double, TreeSet<CartesianPositionCoordinates>>();
        int yDimension = 0;
        for (CartesianPositionCoordinates p : coordinatesSet.getPoints()) {
            TreeSet<CartesianPositionCoordinates> s;
            Double x = new Double(p.getX());
            if (!map.containsKey(x)) {
                s = new TreeSet<CartesianPositionCoordinates>(new CartesianPositionCoordinatesYComparator());
                s.add(p);
                map.put(x, s);
                continue;
            }
            s = (TreeSet<CartesianPositionCoordinates>)map.get(x);
            s.add(p);
            if (s.size() <= yDimension) continue;
            yDimension = s.size();
        }
        int xDimension = map.keySet().size();
        DigitalElevationMap result = ApogyCommonGeometryData3DFactory.eINSTANCE.createDigitalElevationMap();
        result.setXDimension(xDimension);
        result.setYDimension(yDimension);
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        for (Double x : map.keySet()) {
            SortedSet s = (SortedSet)map.get(x);
            for (CartesianPositionCoordinates p : s) {
                CartesianPositionCoordinates copy = this.createCartesianPositionCoordinates(p);
                points.add(copy);
            }
        }
        result.getPoints().addAll(points);
        return result;
    }

    @Override
    public CartesianTriangularMesh concatenateTriangularMeshes(List<CartesianTriangularMesh> listOfTriangularMeshes) {
        CartesianTriangularMesh contatenatedMesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopyMap = new TreeMap<CartesianPositionCoordinates, CartesianPositionCoordinates>(new Geometry3DUtilities.CartesianPositionCoordinatesDistanceComparator());
        for (CartesianTriangularMesh triMesh : listOfTriangularMeshes) {
            for (CartesianPolygon polygon : triMesh.getPolygons()) {
                CartesianTriangle polygonCopy = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangle();
                for (CartesianPositionCoordinates point : polygon.getVertices()) {
                    CartesianPositionCoordinates pointCopy = (CartesianPositionCoordinates)originalToCopyMap.get(point);
                    if (pointCopy == null) {
                        pointCopy = this.createCartesianPositionCoordinates(point);
                        contatenatedMesh.getPoints().add((Object)pointCopy);
                        originalToCopyMap.put(point, pointCopy);
                    }
                    polygonCopy.getVertices().add((Object)pointCopy);
                }
                if (polygonCopy.getVertices().size() != 3) continue;
                contatenatedMesh.getPolygons().add((Object)polygonCopy);
            }
        }
        return contatenatedMesh;
    }

    @Override
    public CartesianCoordinatesSet generatePointCloud(CartesianTriangularMesh cartesianCoordinatesMesh, double resolution) {
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        double pointGenerationResolution = resolution;
        for (CartesianTriangle triangle : cartesianCoordinatesMesh.getPolygons()) {
            try {
                Vector3d normal = triangle.getNormal();
                Point3d p0 = ((CartesianPositionCoordinates)triangle.getVertices().get(0)).asPoint3d();
                Point3d p1 = ((CartesianPositionCoordinates)triangle.getVertices().get(1)).asPoint3d();
                Point3d p2 = ((CartesianPositionCoordinates)triangle.getVertices().get(2)).asPoint3d();
                Vector3d u = new Vector3d((Tuple3d)p1);
                u.sub((Tuple3d)p0);
                Vector3d p0p2 = new Vector3d((Tuple3d)p2);
                p0p2.sub((Tuple3d)p0);
                Vector3d v = new Vector3d();
                v.cross(normal, u);
                v.normalize();
                v.scale(p0p2.length());
                double s = 0.0;
                double t = 0.0;
                double deltaS = 1.0;
                double deltaT = 1.0;
                deltaS = u.length() <= pointGenerationResolution ? 0.5 : pointGenerationResolution / u.length();
                deltaT = v.length() <= pointGenerationResolution ? 0.5 : pointGenerationResolution / v.length();
                if (deltaS != 0.0 && deltaT != 0.0) {
                    while (s <= 1.0 + deltaS) {
                        Vector3d vs = new Vector3d(u);
                        vs.scale(s);
                        t = 0.0;
                        while (t <= 1.0 + deltaT) {
                            Vector3d vt = new Vector3d(v);
                            vt.scale(t);
                            vt.add((Tuple3d)vs);
                            vt.add((Tuple3d)p0);
                            CartesianPositionCoordinates p = this.createCartesianPositionCoordinates(vt.getX(), vt.getY(), vt.getZ());
                            CartesianPositionCoordinates point = Geometry3DUtilities.getProjectionInPolygonPlane(p, triangle);
                            if (point != null && Geometry3DUtilities.isInsidePolygon(point, (CartesianPolygon)triangle)) {
                                points.add(point);
                            }
                            t += deltaT;
                        }
                        s += deltaS;
                    }
                }
                points.addAll(this.generatePointsOnSegment(p0, p1, resolution));
                points.addAll(this.generatePointsOnSegment(p1, p2, resolution));
                points.addAll(this.generatePointsOnSegment(p2, p0, resolution));
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        CartesianCoordinatesSet pointCloud = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        pointCloud.getPoints().addAll(points);
        Logger.info("Generated <" + pointCloud.getPoints().size() + "> raw points.");
        return pointCloud;
    }

    private List<CartesianPositionCoordinates> generatePointsOnSegment(Point3d p0, Point3d p1, double resolution) {
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        Vector3d v = new Vector3d((Tuple3d)p1);
        v.sub((Tuple3d)p0);
        double t = 0.0;
        double deltaT = resolution / v.length();
        while (t <= 1.0 + deltaT) {
            Vector3d w = new Vector3d(v);
            w.scale(deltaT);
            w.add((Tuple3d)p0);
            CartesianPositionCoordinates p = this.createCartesianPositionCoordinates(w.getX(), w.getY(), w.getZ());
            points.add(p);
            t += deltaT;
        }
        return points;
    }

    public CartesianCoordinatesSet createCartesianCoordinatesSet(List<Point3d> points) {
        CartesianCoordinatesSet pointSet = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        for (Point3d point : points) {
            CartesianPositionCoordinates pointCoordinates = this.createCartesianPositionCoordinates(point.x, point.y, point.z);
            pointSet.getPoints().add((Object)pointCoordinates);
        }
        return pointSet;
    }

    @Override
    public RGBAColor createRGBAColor(short alpha, short red, short green, short blue) {
        RGBAColor rgbaColor = ApogyCommonGeometryData3DFactory.eINSTANCE.createRGBAColor();
        rgbaColor.setAlpha(alpha);
        rgbaColor.setRed(red);
        rgbaColor.setGreen(green);
        rgbaColor.setBlue(blue);
        return rgbaColor;
    }

    private class CartesianPositionCoordinatesYComparator
    implements Comparator<CartesianPositionCoordinates> {
        private CartesianPositionCoordinatesYComparator() {
        }

        @Override
        public int compare(CartesianPositionCoordinates o1, CartesianPositionCoordinates o2) {
            if (o1.getY() > o2.getY()) {
                return 1;
            }
            if (o1.getY() < o2.getY()) {
                return -1;
            }
            return 0;
        }
    }
}

