/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.EnergyStorage;
import org.eclipse.apogy.addons.powersystems.PowerConsumer;
import org.eclipse.apogy.addons.powersystems.PowerProvider;
import org.eclipse.apogy.addons.powersystems.PowerSystemEdge;
import org.eclipse.apogy.addons.powersystems.PowerSystemFacade;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.impl.PowerSystemImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class PowerSystemCustomImpl
extends PowerSystemImpl {
    private Job updateJob = null;

    @Override
    public SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> getSystemGraph() {
        SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> tmp = super.getSystemGraph();
        if (tmp == null) {
            tmp = PowerSystemFacade.INSTANCE.createSimpleDirectedWeightedGraph(this);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_SYSTEM__SYSTEM_GRAPH, tmp, true);
        }
        return tmp;
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        if (newEnabled && this.updateJob == null) {
            this.getUpdateJob().schedule();
        } else {
            this.updateJob = null;
        }
    }

    @Override
    public List<SystemElement> getConnectedSystemElementsByTypeAndName(Class<?> elementType, String elementName) {
        ArrayList<SystemElement> results = new ArrayList<SystemElement>();
        for (SystemElement element : this.getElements()) {
            if (!elementType.isAssignableFrom(element.getClass())) continue;
            if (elementName == null) {
                results.add(element);
                continue;
            }
            if (element.getName().compareTo(elementName) != 0) continue;
            results.add(element);
        }
        return results;
    }

    @Override
    public void setTime(Date newTime) {
        this.updateAllSystemElements(newTime);
        super.setTime(newTime);
    }

    private Job getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new Job("Power System Update"){

                protected IStatus run(IProgressMonitor arg0) {
                    while (PowerSystemCustomImpl.this.isEnabled()) {
                        Date now = new Date();
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)PowerSystemCustomImpl.this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.TIMED__TIME, (Object)now, true);
                            long delay = Math.round(PowerSystemCustomImpl.this.getUpdatePeriod() * 1000.0);
                            Thread.sleep(delay);
                        }
                        catch (Exception exception) {}
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.updateJob;
    }

    private void updateAllSystemElements(Date time) {
        ArrayList<SystemElement> updated = new ArrayList<SystemElement>();
        ArrayList<SystemElement> remaining = new ArrayList<SystemElement>((Collection<SystemElement>)this.getElements());
        List<SystemElement> powerProviders = this.getConnectedSystemElementsByTypeAndName(PowerProvider.class, null);
        for (SystemElement element : powerProviders) {
            if (updated.contains(element)) continue;
            element.update(time);
            updated.add(element);
            remaining.remove(element);
        }
        List<SystemElement> powerSinks = this.getConnectedSystemElementsByTypeAndName(PowerConsumer.class, null);
        for (SystemElement element : powerSinks) {
            if (updated.contains(element)) continue;
            element.update(time);
            updated.add(element);
            remaining.remove(element);
        }
        List<SystemElement> energyStorages = this.getConnectedSystemElementsByTypeAndName(EnergyStorage.class, null);
        for (SystemElement element : energyStorages) {
            if (updated.contains(element)) continue;
            element.update(time);
            updated.add(element);
            remaining.remove(element);
        }
        for (SystemElement element : remaining) {
            if (updated.contains(element)) continue;
            element.update(time);
            updated.add(element);
        }
    }
}

