/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PowerConverterState implements Enumerator
{
    ON(0, "ON", "On"),
    SHUTDOWN(1, "SHUTDOWN", "Shutdown");

    public static final int ON_VALUE = 0;
    public static final int SHUTDOWN_VALUE = 1;
    private static final PowerConverterState[] VALUES_ARRAY;
    public static final List<PowerConverterState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PowerConverterState[]{ON, SHUTDOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PowerConverterState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerConverterState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerConverterState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerConverterState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerConverterState get(int value) {
        switch (value) {
            case 0: {
                return ON;
            }
            case 1: {
                return SHUTDOWN;
            }
        }
        return null;
    }

    private PowerConverterState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

