/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PowerBusState implements Enumerator
{
    NOMINAL(0, "NOMINAL", "Nominal"),
    OVERLOADED(1, "OVERLOADED", "Overloaded"),
    LOAD_SHEDDING(2, "LOAD_SHEDDING", "Load Shedding");

    public static final int NOMINAL_VALUE = 0;
    public static final int OVERLOADED_VALUE = 1;
    public static final int LOAD_SHEDDING_VALUE = 2;
    private static final PowerBusState[] VALUES_ARRAY;
    public static final List<PowerBusState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PowerBusState[]{NOMINAL, OVERLOADED, LOAD_SHEDDING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PowerBusState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerBusState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerBusState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PowerBusState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PowerBusState get(int value) {
        switch (value) {
            case 0: {
                return NOMINAL;
            }
            case 1: {
                return OVERLOADED;
            }
            case 2: {
                return LOAD_SHEDDING;
            }
        }
        return null;
    }

    private PowerBusState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

