/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.powersystems.AbstractInputElement;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.EnergyStorage;
import org.eclipse.apogy.addons.powersystems.PowerBusState;
import org.eclipse.apogy.addons.powersystems.PowerConsumer;
import org.eclipse.apogy.addons.powersystems.PowerSource;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.PowerSystemFacade;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.impl.PowerBusImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PowerBusCustomImpl
extends PowerBusImpl {
    @Override
    public boolean isPowerStateValid() {
        return true;
    }

    @Override
    public void connectOutput(AbstractInputElement target) {
        if (target != null) {
            this.getOutputs().add((Object)target);
            if (target != null) {
                target.connectInput(this);
            }
        }
    }

    @Override
    public void disconnectOutput(AbstractInputElement target) {
        if (target != null) {
            this.getOutputs().remove((Object)target);
            if (target != null) {
                target.disconnectInput(this);
            }
        }
    }

    @Override
    public void update(Date time) {
        double powerLoad = this.getPowerLoad();
        double powerSourceAvailablePower = this.getPowerSourceAvailablePower();
        double energyStorageAvailablePower = this.getEnergyStorageAvailablePower();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__TOTAL_POWER_LOAD, (Object)powerLoad, true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_AVAILABLE_FROM_SOURCES, (Object)powerSourceAvailablePower, true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_AVAILABLE_FROM_ENERGY_STORAGE, (Object)energyStorageAvailablePower, true);
        if (powerSourceAvailablePower >= powerLoad) {
            double availablePower = powerSourceAvailablePower - powerLoad;
            double energyStorageAvailableInputPower = this.getEnergyStorageAvailableStorage();
            double powerToStore = energyStorageAvailableInputPower;
            if (powerToStore > availablePower) {
                powerToStore = availablePower;
            }
            double totalPowerFromSources = powerLoad + powerToStore;
            this.spreadLoadToPowerSource(totalPowerFromSources);
            this.fillEnergyStorage(powerToStore);
            this.setPowerBusState(PowerBusState.NOMINAL);
            this.setBusPowerOverload(0.0);
            this.setPowerBalance(powerToStore);
        } else {
            double powerDeficit = powerLoad - powerSourceAvailablePower;
            if (energyStorageAvailablePower >= powerDeficit) {
                this.spreadLoadToPowerSource(powerSourceAvailablePower);
                this.spreadLoadToPowerStorage(powerDeficit);
                this.setPowerBalance(-powerDeficit);
                this.setPowerBusState(PowerBusState.NOMINAL);
                this.setBusPowerOverload(0.0);
            } else {
                this.setPowerBusState(PowerBusState.OVERLOADED);
                this.setBusPowerOverload(Math.abs(energyStorageAvailablePower - powerDeficit));
                this.setPowerBalance(energyStorageAvailablePower - powerDeficit);
                this.loadShed(this.getBusPowerOverload());
            }
        }
        this.distributePowerToLoads(powerLoad);
    }

    @Override
    public List<PowerConsumer> getConnectedConsumers() {
        List<SystemElement> outputs = PowerSystemFacade.INSTANCE.getAllOutputs(this.getPowerSystem().getSystemGraph(), this);
        ArrayList<PowerConsumer> consumers = new ArrayList<PowerConsumer>();
        for (SystemElement element : outputs) {
            if (!(element instanceof PowerConsumer)) continue;
            consumers.add((PowerConsumer)element);
        }
        return consumers;
    }

    @Override
    public List<PowerSource> getConnectedPowerSources() {
        ArrayList<PowerSource> sources = new ArrayList<PowerSource>();
        for (SystemElement element : this.getInputs()) {
            List<SystemElement> subs = PowerSystemFacade.INSTANCE.getAllInputs(this.getPowerSystem().getSystemGraph(), element);
            for (SystemElement el : subs) {
                if (!(el instanceof PowerSource) || sources.contains(el)) continue;
                sources.add((PowerSource)el);
            }
        }
        return sources;
    }

    @Override
    public List<EnergyStorage> getConnectedEnergyStorage() {
        ArrayList<EnergyStorage> storages = new ArrayList<EnergyStorage>();
        for (SystemElement element : this.getInputs()) {
            if (!(element instanceof EnergyStorage) || storages.contains(element)) continue;
            storages.add((EnergyStorage)element);
        }
        for (SystemElement element : this.getOutputs()) {
            if (!(element instanceof EnergyStorage) || storages.contains(element)) continue;
            storages.add((EnergyStorage)element);
        }
        return storages;
    }

    protected double getPowerLoad() {
        double powerLoad = 0.0;
        powerLoad = PowerSystemFacade.INSTANCE.findRequiredPowerFromConsumer(this.getPowerSystem().getSystemGraph(), this);
        return powerLoad;
    }

    protected double getPowerSourceAvailablePower() {
        List<PowerSource> sources = this.getConnectedPowerSources();
        double totalAvailablePower = 0.0;
        for (PowerSource source : sources) {
            if (source instanceof EnergyStorage) continue;
            double efficiency = 1.0;
            try {
                efficiency = PowerSystemFacade.INSTANCE.computeEfficiency(this.getPowerSystem().getSystemGraph(), source, this) / 100.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            totalAvailablePower += source.getPowerAvailable() * efficiency;
        }
        return totalAvailablePower;
    }

    protected double getEnergyStorageAvailablePower() {
        List<EnergyStorage> storages = this.getConnectedEnergyStorage();
        double totalAvailablePower = 0.0;
        for (EnergyStorage storage : storages) {
            totalAvailablePower += storage.getMaximumPowerOuput();
        }
        return totalAvailablePower;
    }

    protected double getEnergyStorageAvailableStorage() {
        List<EnergyStorage> storages = this.getConnectedEnergyStorage();
        double totalAvailablePowerStorage = 0.0;
        for (EnergyStorage storage : storages) {
            double efficiency = 100.0;
            try {
                efficiency = PowerSystemFacade.INSTANCE.computeEfficiency(this.getPowerSystem().getSystemGraph(), this, storage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            totalAvailablePowerStorage += storage.getMaximumPowerInput() * (1.0 / (efficiency / 100.0));
        }
        return totalAvailablePowerStorage;
    }

    protected void updateAllElements(Date time) {
        for (SystemElement element : this.getInputs()) {
            try {
                element.update(time);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (SystemElement element : this.getOutputs()) {
            try {
                element.update(time);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void distributePowerToLoads(double powerLoad) {
        PowerSystemFacade.INSTANCE.propagatePowerToConsumer(this.getPowerSystem().getSystemGraph(), this, powerLoad);
    }

    protected void spreadLoadToPowerSource(double powerLoad) {
        PowerSystemFacade.INSTANCE.propagatePowerDemandToPowerSources(this.getPowerSystem().getSystemGraph(), this, powerLoad);
    }

    protected double spreadLoadToPowerStorage(double powerLoad) {
        double powerProvided = 0.0;
        List<EnergyStorage> storages = this.getConnectedEnergyStorage();
        double totalAvailablePower = 0.0;
        for (EnergyStorage storage : storages) {
            totalAvailablePower += storage.getMaximumPowerOuput();
        }
        if (totalAvailablePower >= Math.abs(powerLoad)) {
            for (EnergyStorage storage : storages) {
                double weight = storage.getMaximumPowerOuput() / totalAvailablePower;
                storage.drawPower(weight * Math.abs(powerLoad));
            }
            powerProvided = Math.abs(powerLoad);
        } else {
            for (EnergyStorage storage : storages) {
                powerProvided += storage.drawPower(storage.getMaximumPowerOuput());
            }
        }
        return powerProvided;
    }

    protected double fillEnergyStorage(double sparePower) {
        double powerStored;
        block8: {
            List<EnergyStorage> storages;
            block7: {
                powerStored = 0.0;
                storages = this.getConnectedEnergyStorage();
                if (!(sparePower > 0.0)) break block7;
                double totalAvailablePowerStorage = 0.0;
                for (EnergyStorage storage : storages) {
                    totalAvailablePowerStorage += storage.getMaximumPowerInput();
                }
                if (!(totalAvailablePowerStorage > 0.0)) break block8;
                if (totalAvailablePowerStorage >= Math.abs(sparePower)) {
                    for (EnergyStorage storage : storages) {
                        double weight = storage.getMaximumPowerInput() / totalAvailablePowerStorage;
                        storage.storePower(weight * Math.abs(sparePower));
                    }
                    powerStored = sparePower;
                } else {
                    for (EnergyStorage storage : storages) {
                        powerStored += storage.storePower(Math.abs(storage.getMaximumPowerInput()));
                    }
                }
                break block8;
            }
            if (sparePower == 0.0) {
                for (EnergyStorage storage : storages) {
                    storage.storePower(0.0);
                }
            }
        }
        return powerStored;
    }

    protected List<PowerSwitch> loadShed(double overPowerValue) {
        this.setPowerBusState(PowerBusState.LOAD_SHEDDING);
        ArrayList<PowerSwitch> switchedOff = new ArrayList<PowerSwitch>();
        double remainingOverPower = overPowerValue;
        Iterator it = this.getLoadSheddingSwitches().iterator();
        while (it.hasNext() && remainingOverPower > 0.0) {
            PowerSwitch powerSwitch = (PowerSwitch)it.next();
            double powerRequiredAtSwitch = PowerSystemFacade.INSTANCE.findRequiredPowerFromConsumer(this.getPowerSystem().getSystemGraph(), powerSwitch);
            remainingOverPower -= powerRequiredAtSwitch;
            powerSwitch.switchOff();
            switchedOff.add(powerSwitch);
        }
        if (remainingOverPower > 0.0) {
            this.setPowerBusState(PowerBusState.OVERLOADED);
        }
        return switchedOff;
    }
}

