/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.pathplanners.graph.impl;

import java.util.HashMap;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.impl.DistanceAndRoverFootprintCostFunctionImpl;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;

public class DistanceAndRoverFootprintCostFunctionCustomImpl
extends DistanceAndRoverFootprintCostFunctionImpl {
    private static HashMap<CartesianPolygon, Set<CartesianPolygon>> polygonToNeibours = new HashMap();
    private static HashMap<CartesianPolygon, Vector3d> polygonToAverageNormal = new HashMap();

    private Set<CartesianPolygon> getPolygonsWithinRadius(Mesh<CartesianPositionCoordinates, CartesianPolygon> mesh, CartesianPolygon center) {
        Set polygons = polygonToNeibours.get(center);
        if (polygons == null) {
            polygons = Geometry3DUtilities.getCartesianPolygonsPartiallyWithinRadius((CartesianPolygon)center, (double)this.getRoverFootPrintRadius(), mesh);
            polygonToNeibours.put(center, polygons);
        }
        return polygons;
    }

    private Vector3d getAverageNormal(Mesh<CartesianPositionCoordinates, CartesianPolygon> mesh, CartesianPolygon polygon) {
        Vector3d normal = polygonToAverageNormal.get(polygon);
        if (normal == null) {
            normal = Geometry3DUtilities.getAverageNormal(this.getPolygonsWithinRadius(mesh, polygon));
            polygonToAverageNormal.put(polygon, normal);
        }
        return normal;
    }

    @Override
    public double getCost(CartesianPolygon from, CartesianPolygon to) {
        double cost = 0.0;
        Vector3d averageNormal = new Vector3d();
        Set<CartesianPolygon> polygonsWithinRadius = this.getPolygonsWithinRadius((Mesh<CartesianPositionCoordinates, CartesianPolygon>)this.getPlanner().getMesh(), to);
        averageNormal = this.getAverageNormal((Mesh<CartesianPositionCoordinates, CartesianPolygon>)this.getPlanner().getMesh(), to);
        cost = this.computeSegmentCost(from, to, averageNormal, polygonsWithinRadius);
        if (cost == Double.POSITIVE_INFINITY) {
            return cost;
        }
        return cost += 2.0 * this.getHeuristicCost(to.getCentroid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double computeSegmentCost(CartesianPolygon from, CartesianPolygon to, Vector3d normal, Set<CartesianPolygon> polygonsWithinRadius) {
        Vector3d crossTrack = new Vector3d();
        Vector3d alongTrack = new Vector3d();
        Point3d p1 = from.getCentroid().asPoint3d();
        Point3d p2 = to.getCentroid().asPoint3d();
        double cost = 0.0;
        double distance = p1.distance(p2);
        Vector3d pathDirection = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        crossTrack.cross(normal, pathDirection);
        alongTrack.cross(crossTrack, normal);
        double alongSlopeAngle = this.computeSlopeAngle(alongTrack);
        double crossSlopeAngle = this.computeSlopeAngle(crossTrack);
        if (alongSlopeAngle >= 0.0) {
            if (!(alongSlopeAngle < Math.abs(this.getMaximumUpSlope()))) return Double.POSITIVE_INFINITY;
            double slopeCost = Math.abs(this.getUpSlopeCostFactor() * (alongSlopeAngle / this.getMaximumUpSlope()));
            cost = distance * (1.0 + slopeCost);
        } else {
            if (!(Math.abs(alongSlopeAngle) < Math.abs(this.getMaximumDownSlope()))) return Double.POSITIVE_INFINITY;
            cost = distance;
        }
        if (Math.abs(crossSlopeAngle) > Math.abs(this.getMaximumCrossSlope())) {
            return Double.POSITIVE_INFINITY;
        }
        double roughnessIndex = Geometry3DUtilities.getSurfaceRoughnessIndex(polygonsWithinRadius, (Vector3d)normal, (CartesianPolygon)to, (double)this.getRoverFootPrintRadius());
        if (!(roughnessIndex > this.getMaximumRoughness())) return cost;
        return Double.POSITIVE_INFINITY;
    }

    private double computeSlopeAngle(Vector3d vector) {
        double elevationChange = 0.0;
        double distance = 0.0;
        switch (this.getGravityAxis().getValue()) {
            case 0: {
                elevationChange = vector.x;
                distance = Math.sqrt(vector.y * vector.y + vector.z * vector.z);
                break;
            }
            case 1: {
                elevationChange = vector.y;
                distance = Math.sqrt(vector.x * vector.x + vector.z * vector.z);
                break;
            }
            case 2: {
                elevationChange = vector.z;
                distance = Math.sqrt(vector.x * vector.x + vector.y * vector.y);
            }
        }
        return Math.atan2(elevationChange, distance);
    }

    private double getHeuristicCost(CartesianPositionCoordinates to) {
        Point3d destination = this.getPlanner().getCurrentDestination().asPoint3d();
        double distanceToGoal = 0.0;
        distanceToGoal = to.asPoint3d().distance(destination);
        return distanceToGoal;
    }
}

