/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.pathplanners.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector2d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.mobility.pathplanners.graph.MobilityEdge;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class GraphUtilities {
    public static SimpleDirectedWeightedGraph createGraph(Mesh cartesianMesh, EdgeFactory edgeFactory, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor;
        if (internalMonitor == null) {
            internalMonitor = new NullProgressMonitor();
        }
        SimpleDirectedWeightedGraph simpleDirectedWeightedGraph = new SimpleDirectedWeightedGraph(edgeFactory){

            public double getEdgeWeight(Object e) {
                if (e instanceof MobilityEdge) {
                    return ((MobilityEdge)e).getWeight();
                }
                return 1.0;
            }
        };
        internalMonitor.subTask("Creating <" + cartesianMesh.getPolygons().size() + "> Vertices...");
        for (CartesianPolygon polygon : cartesianMesh.getPolygons()) {
            if (polygon.getVertices().size() >= 3) {
                simpleDirectedWeightedGraph.addVertex((Object)polygon);
            }
            internalMonitor.worked(1);
        }
        internalMonitor.subTask("Creating Edges...");
        for (CartesianPolygon polygon : simpleDirectedWeightedGraph.vertexSet()) {
            EList neighbours = cartesianMesh.getPolygonNeighbours((Polygon)polygon);
            ArrayList<CartesianPolygon> edgeNeighbours = new ArrayList<CartesianPolygon>();
            for (CartesianPolygon neighbour : neighbours) {
                if (Geometry3DUtilities.getSharedVertices((CartesianPolygon)polygon, (CartesianPolygon)neighbour).size() <= 1) continue;
                edgeNeighbours.add(neighbour);
            }
            for (CartesianPolygon neighbor : edgeNeighbours) {
                simpleDirectedWeightedGraph.addEdge((Object)polygon, (Object)neighbor);
            }
            internalMonitor.worked(1);
        }
        internalMonitor.done();
        return simpleDirectedWeightedGraph;
    }

    public static WayPointPath getPathThroughPolygonsCentroid(List<CartesianPolygon> polygons) {
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        for (CartesianPolygon polygon : polygons) {
            CartesianPositionCoordinates centroid = Geometry3DUtilities.getCentroid((List)polygon.getVertices());
            path.getPoints().add((Object)centroid);
        }
        return path;
    }

    public static <T extends CartesianPolygon> WayPointPath getSimplifiedPathThroughPolygonsCentroid(CartesianPlane cartesianPlane, CartesianPositionCoordinates start, CartesianPositionCoordinates destination, List<T> polygons, double robotWidth) {
        if (cartesianPlane != CartesianPlane.XY) {
            throw new UnsupportedOperationException("getSimplifiedPathThroughPolygonsCentroid only supported for XY plane !");
        }
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        path.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(start));
        if (polygons.size() >= 2) {
            Iterator<T> it = polygons.iterator();
            CartesianPolygon p0 = (CartesianPolygon)it.next();
            CartesianPolygon p1 = (CartesianPolygon)it.next();
            ArrayList<CartesianPolygon> polygonsSubPath = new ArrayList<CartesianPolygon>();
            polygonsSubPath.add(p0);
            polygonsSubPath.add(p1);
            CartesianPositionCoordinates segmentStart = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(start);
            CartesianPositionCoordinates segmentEnd = p1.getCentroid();
            while (it.hasNext()) {
                if (GraphUtilities.isReacheable(cartesianPlane, segmentStart, segmentEnd, polygonsSubPath)) {
                    polygonsSubPath.add(p1);
                } else {
                    segmentStart = p0.getCentroid();
                    path.getPoints().add((Object)segmentStart);
                    polygonsSubPath.clear();
                    polygonsSubPath.add(p0);
                }
                p0 = p1;
                p1 = (CartesianPolygon)it.next();
                segmentEnd = p1.getCentroid();
            }
        }
        path.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(destination));
        return path;
    }

    public static Vector2d intersection(Vector2d u1, Vector2d u2, Vector2d v1, Vector2d v2) {
        double d = (u1.x - u2.x) * (v1.y - v2.y) - (u1.y - u2.y) * (v1.x - v2.x);
        if (d == 0.0) {
            return null;
        }
        double xi = ((v1.x - v2.x) * (u1.x * u2.y - u1.y * u2.x) - (u1.x - u2.x) * (v1.x * v2.y - v1.y * v2.x)) / d;
        double yi = ((v1.y - v2.y) * (u1.x * u2.y - u1.y * u2.x) - (u1.y - u2.y) * (v1.x * v2.y - v1.y * v2.x)) / d;
        return new Vector2d(xi, yi);
    }

    private static <T extends CartesianPolygon> boolean isReacheable(CartesianPlane cartesianPlane, CartesianPositionCoordinates segmentStart, CartesianPositionCoordinates segmentEnd, List<T> polygons) {
        return Geometry3DUtilities.isLineIntersectsAllPolygons((CartesianPlane)cartesianPlane, (CartesianPositionCoordinates)segmentStart, (CartesianPositionCoordinates)segmentEnd, polygons);
    }

    public static List<MobilityEdge> getDijkstraShortestPath(Graph graph, CartesianPolygon from, CartesianPolygon to) {
        ArrayList<MobilityEdge> edgeList = new ArrayList<MobilityEdge>();
        List temp = DijkstraShortestPath.findPathBetween((Graph)graph, (Object)from, (Object)to);
        for (MobilityEdge edge : temp) {
            edgeList.add(edge);
        }
        return edgeList;
    }

    public static List<CartesianPolygon> getPolygonPath(List<MobilityEdge> edges) {
        ArrayList<CartesianPolygon> polygonPath = new ArrayList<CartesianPolygon>();
        if (edges.size() > 0) {
            polygonPath.add(edges.get(0).getFrom());
            for (MobilityEdge edge : edges) {
                polygonPath.add(edge.getTo());
            }
        }
        return polygonPath;
    }

    public static double getPathCost(List<MobilityEdge> edges) {
        double cost = 0.0;
        Iterator<MobilityEdge> it = edges.iterator();
        while (it.hasNext() && cost != Double.POSITIVE_INFINITY) {
            cost += it.next().getWeight();
        }
        return cost;
    }
}

