/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    public void addSamplePoint(T x, T[] ... value) throws ZeroException, MathArithmeticException, DimensionMismatchException, NullArgumentException {
        MathUtils.checkNotNull(x);
        FieldElement factorial = (FieldElement)x.getField().getOne();
        int i = 0;
        while (i < value.length) {
            FieldElement[] y = (FieldElement[])value[i].clone();
            if (i > 1) {
                factorial = (FieldElement)factorial.multiply(i);
                FieldElement inv = (FieldElement)factorial.reciprocal();
                int j = 0;
                while (j < y.length) {
                    y[j] = y[j].multiply(inv);
                    ++j;
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, y);
            FieldElement[] bottom0 = y;
            int j = i;
            while (j < n) {
                FieldElement[] bottom1 = (FieldElement[])this.bottomDiagonal.get(n - (j + 1));
                if (x.equals(this.abscissae.get(n - (j + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, x);
                }
                FieldElement inv = (FieldElement)x.subtract((FieldElement)((FieldElement)this.abscissae.get(n - (j + 1)))).reciprocal();
                int k = 0;
                while (k < y.length) {
                    bottom1[k] = inv.multiply(bottom0[k].subtract(bottom1[k]));
                    ++k;
                }
                bottom0 = bottom1;
                ++j;
            }
            this.topDiagonal.add((FieldElement[])bottom0.clone());
            this.abscissae.add(x);
            ++i;
        }
    }

    public T[] value(T x) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(x);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] value = (FieldElement[])MathArrays.buildArray(x.getField(), ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement valueCoeff = (FieldElement)x.getField().getOne();
        int i = 0;
        while (i < this.topDiagonal.size()) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i);
            int k = 0;
            while (k < value.length) {
                value[k] = value[k].add(dividedDifference[k].multiply(valueCoeff));
                ++k;
            }
            FieldElement deltaX = x.subtract((FieldElement)((FieldElement)this.abscissae.get(i)));
            valueCoeff = valueCoeff.multiply(deltaX);
            ++i;
        }
        return value;
    }

    public T[][] derivatives(T x, int order) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(x);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement zero = (FieldElement)x.getField().getZero();
        FieldElement one = (FieldElement)x.getField().getOne();
        FieldElement[] tj = (FieldElement[])MathArrays.buildArray(x.getField(), order + 1);
        tj[0] = zero;
        int i = 0;
        while (i < order) {
            tj[i + 1] = tj[i].add(one);
            ++i;
        }
        FieldElement[][] derivatives = (FieldElement[][])MathArrays.buildArray(x.getField(), order + 1, ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] valueCoeff = (FieldElement[])MathArrays.buildArray(x.getField(), order + 1);
        valueCoeff[0] = (FieldElement)x.getField().getOne();
        int i2 = 0;
        while (i2 < this.topDiagonal.size()) {
            FieldElement[] dividedDifference = (FieldElement[])this.topDiagonal.get(i2);
            FieldElement deltaX = x.subtract((FieldElement)((FieldElement)this.abscissae.get(i2)));
            int j = order;
            while (j >= 0) {
                int k = 0;
                while (k < derivatives[j].length) {
                    derivatives[j][k] = derivatives[j][k].add(dividedDifference[k].multiply(valueCoeff[j]));
                    ++k;
                }
                valueCoeff[j] = valueCoeff[j].multiply(deltaX);
                if (j > 0) {
                    valueCoeff[j] = valueCoeff[j].add(tj[j].multiply(valueCoeff[j - 1]));
                }
                --j;
            }
            ++i2;
        }
        return derivatives;
    }
}

