/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.manager.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sequoyah.device.common.utilities.exception.ExceptionHandler;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.exception.DeviceExceptionHandler;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.manager.persistence.IDeviceXmlTags;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceXmlReader
implements IDeviceXmlTags {
    public static Collection<IInstance> loadInstances(File file) {
        ArrayList<IInstance> arrayList = new ArrayList<IInstance>();
        if (file.exists()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                Element element = document.getDocumentElement();
                arrayList.addAll(DeviceXmlReader.parseInstancesList(element));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }
        return arrayList;
    }

    private static Collection<IInstance> parseInstancesList(Element element) {
        Node node;
        LinkedHashSet<IInstance> linkedHashSet = new LinkedHashSet<IInstance>();
        NodeList nodeList = element.getElementsByTagName("instances");
        if (nodeList != null && nodeList.getLength() == 1 && (node = nodeList.item(0)).getNodeType() == 1) {
            Element element2 = (Element)node;
            NodeList nodeList2 = element2.getElementsByTagName("instance");
            int n = 0;
            while (nodeList2 != null && n < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n);
                if (node2.getNodeType() == 1) {
                    Element element3 = (Element)node2;
                    String string = element3.getAttribute("deviceType_id");
                    String string2 = element3.getAttribute("name");
                    Properties properties = new Properties();
                    NodeList nodeList3 = element3.getChildNodes();
                    int n2 = 0;
                    while (nodeList3 != null && n2 < nodeList3.getLength()) {
                        Node node3 = nodeList3.item(n2);
                        if (node3.getNodeType() == 1) {
                            Element element4 = (Element)node3;
                            properties.put(element4.getTagName(), element4.getTextContent());
                        }
                        ++n2;
                    }
                    IInstance iInstance = null;
                    if (string2 != null && !string2.equals("") && string != null && !string.equals("")) {
                        try {
                            iInstance = InstanceManager.createInstance(string2, string, "OFF", properties);
                            linkedHashSet.add(iInstance);
                        }
                        catch (SequoyahException sequoyahException) {
                            ExceptionHandler.showException((SequoyahException)DeviceExceptionHandler.exception(202));
                        }
                    }
                }
                ++n;
            }
        }
        return linkedHashSet;
    }
}

