/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.SolidRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVBO;
import org.eclipse.draw3d.util.BufferUtils;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LwjglPolygonVBO
extends LwjglVBO {
    private static final int ALLOWED_TYPES = 7;
    private int m_type;
    private List<float[]> m_vertices = new LinkedList<float[]>();
    private int m_vertexCount = 0;
    private IntBuffer m_indexBuffer;
    private IntBuffer m_countBuffer;
    private float[] m_color;
    private boolean m_solid;

    public LwjglPolygonVBO(int i_type, RenderRule i_renderRule) {
        if ((i_type & 7) == 0) {
            throw new IllegalArgumentException(String.valueOf(i_type) + " is not a valid polygon type");
        }
        this.m_type = i_type;
        if (i_renderRule.isSolid()) {
            SolidRenderRule solid = i_renderRule.asSolid();
            this.m_color = ColorConverter.toFloatArray((Color)solid.getColor(), (int)solid.getAlpha(), null);
            this.m_solid = true;
        } else if (i_renderRule.isOutline()) {
            OutlineRenderRule outline = i_renderRule.asOutline();
            this.m_color = ColorConverter.toFloatArray((Color)outline.getColor(), (int)outline.getAlpha(), null);
            this.m_solid = false;
        } else if (i_renderRule.isText()) {
            TextRenderRule text = i_renderRule.asText();
            this.m_color = ColorConverter.toFloatArray((Color)text.getTextColor(), (int)text.getAlpha(), null);
            this.m_solid = true;
        } else {
            throw new IllegalArgumentException("cannot handle render rule " + i_renderRule);
        }
    }

    public void addPolygon(List<IVector2f> i_vertices) {
        if (i_vertices == null) {
            throw new NullPointerException("i_vertices must not be null");
        }
        float[] data = new float[2 * i_vertices.size()];
        int i = 0;
        for (IVector2f v : i_vertices) {
            v.toArray(data, 2 * i++);
        }
        this.m_vertices.add(data);
        this.m_vertexCount += i_vertices.size();
    }

    @Override
    protected void cleanup(Graphics3D i_g3d, ILodHelper i_lodContext) {
        if (!this.m_solid) {
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        GL14.glMultiDrawArrays((int)this.m_type, (IntBuffer)this.m_indexBuffer, (IntBuffer)this.m_countBuffer);
    }

    @Override
    protected void stateChanged(LwjglVBO.State i_oldState, LwjglVBO.State i_newState) {
        super.stateChanged(i_oldState, i_newState);
        if (i_newState == LwjglVBO.State.READY) {
            this.m_vertices = null;
        }
    }

    @Override
    protected Buffer getBuffer(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.VERTEX) {
            FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(2 * this.m_vertexCount));
            this.m_indexBuffer = BufferUtils.createIntBuffer((int)this.m_vertices.size());
            this.m_countBuffer = BufferUtils.createIntBuffer((int)this.m_vertices.size());
            int index = 0;
            for (float[] vertices : this.m_vertices) {
                vertexBuffer.put(vertices);
                this.m_indexBuffer.put(index);
                int vertexCount = vertices.length / 2;
                this.m_countBuffer.put(vertexCount);
                index += vertexCount;
            }
            this.m_indexBuffer.rewind();
            this.m_countBuffer.rewind();
            return vertexBuffer;
        }
        return null;
    }

    @Override
    protected LwjglVBO.BufferInfo getBufferInfo(LwjglVBO.BufferType i_type) {
        if (i_type == LwjglVBO.BufferType.VERTEX) {
            return new LwjglVBO.BufferInfo(5126, 35041, 2, 0, 0);
        }
        return null;
    }

    @Override
    protected boolean hasBuffer(LwjglVBO.BufferType i_type) {
        return i_type == LwjglVBO.BufferType.VERTEX;
    }

    @Override
    protected void prepare(Graphics3D i_g3d, ILodHelper i_lodContext) {
        i_g3d.glColor4f(this.m_color);
        if (this.m_solid) {
            GL11.glPolygonMode((int)1032, (int)6914);
        } else {
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        }
    }
}

