/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableFloatBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.primitive.FloatBags;

@ServiceProvider(value=ImmutableFloatBagFactory.class)
public class ImmutableFloatBagFactoryImpl
implements ImmutableFloatBagFactory {
    public static final ImmutableFloatBagFactory INSTANCE = new ImmutableFloatBagFactoryImpl();

    public ImmutableFloatBag empty() {
        return ImmutableFloatEmptyBag.INSTANCE;
    }

    public ImmutableFloatBag of() {
        return this.empty();
    }

    public ImmutableFloatBag with() {
        return this.empty();
    }

    public ImmutableFloatBag of(float one) {
        return this.with(one);
    }

    public ImmutableFloatBag with(float one) {
        return new ImmutableFloatSingletonBag(one);
    }

    public ImmutableFloatBag of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatBag with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatHashBag.newBagWith(items);
    }

    public ImmutableFloatBag ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatBag withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatBag) {
            return (ImmutableFloatBag)items;
        }
        if (items == null) {
            return this.with();
        }
        FloatHashBag bag = new FloatHashBag();
        items.forEach(arg_0 -> ((MutableFloatBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableFloatHashBag.newBagWith(bag);
    }

    public ImmutableFloatBag ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableFloatBag withAll(Iterable<Float> iterable) {
        return FloatBags.mutable.withAll(iterable).toImmutable();
    }
}

