# frozen_string_literal: true

require 'capybara/selenium/extensions/html5_drag'

class Capybara::Selenium::ChromeNode < Capybara::Selenium::Node
  include Html5Drag

  def set_file(value) # rubocop:disable Naming/AccessorMethodName
    super(value)
  rescue ::Selenium::WebDriver::Error::ExpectedError => err
    if err.message =~ /File not found : .+\n.+/m
      raise ArgumentError, "Selenium < 3.14 with remote Chrome doesn't support multiple file upload"
    end

    raise
  end

  def drag_to(element)
    return super unless html5_draggable?

    html5_drag_to(element)
  end

private

  def bridge
    driver.browser.send(:bridge)
  end
end
