/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class TextRulerStatisticsCollector {
    protected int p = 0;
    protected int n = 0;
    protected Set<TextRulerExample> coveredPositives = new HashSet<TextRulerExample>();
    protected Set<TextRulerExample> coveredNegatives = new HashSet<TextRulerExample>();

    public TextRulerStatisticsCollector() {
    }

    public TextRulerStatisticsCollector(TextRulerStatisticsCollector c) {
        this.p = c.p;
        this.n = c.n;
        this.coveredPositives.addAll(c.coveredPositives);
        this.coveredNegatives.addAll(c.coveredNegatives);
    }

    public int getTotalCoveredExamples() {
        return this.p + this.n;
    }

    public int getCoveredPositivesCount() {
        return this.p;
    }

    public int getCoveredNegativesCount() {
        return this.n;
    }

    public Set<TextRulerExample> getCoveredPositiveExamples() {
        return this.coveredPositives;
    }

    public Set<TextRulerExample> getCoveredNegativeExamples() {
        return this.coveredNegatives;
    }

    public void reflectCountsFromCoveredExamples() {
        this.p = this.coveredPositives.size();
        this.n = this.coveredNegatives.size();
    }

    public void reset() {
        this.p = 0;
        this.n = 0;
        this.coveredPositives.clear();
        this.coveredNegatives.clear();
    }

    public void incCoveredPositives(int count) {
        this.p += count;
    }

    public void incCoveredNegatives(int count) {
        this.n += count;
    }

    public void addCoveredPositive(TextRulerExample e) {
        if (this.coveredPositives.add(e)) {
            this.incCoveredPositives(1);
        } else {
            TextRulerToolkit.logIfDebug("TRIED TO ADD A POSITIVE COVERED EXAMPLE TWICE !!");
        }
    }

    public void addCoveredNegative(TextRulerExample e) {
        if (this.coveredNegatives.add(e)) {
            this.incCoveredNegatives(1);
        } else {
            TextRulerToolkit.logIfDebug("TRIED TO ADD A NEGATIVE COVERED EXAMPLE TWICE !!");
        }
    }

    public TextRulerStatisticsCollector copy() {
        return new TextRulerStatisticsCollector(this);
    }

    public void add(TextRulerStatisticsCollector c) {
        this.incCoveredNegatives(c.n);
        this.incCoveredPositives(c.p);
        this.coveredPositives.addAll(c.coveredPositives);
        this.coveredNegatives.addAll(c.coveredNegatives);
    }

    public String toString() {
        return "p=" + this.p + "; n=" + this.n;
    }
}

