/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.engine.StyleMapFactory;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaModifier
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODIFIED_VIEW = "modified";
    public static final String OUTPUT_LOCATION = "outputLocation";
    public static final String OUTPUT_VIEW = "outputView";
    private StyleMapFactory styleMapFactory;
    private String styleMapLocation;
    private String[] descriptorPaths;
    private String outputLocation;
    private String modifiedViewName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.styleMapLocation = (String)aContext.getConfigParameterValue("styleMap");
        this.descriptorPaths = (String[])aContext.getConfigParameterValue("descriptorPaths");
        this.outputLocation = (String)aContext.getConfigParameterValue(OUTPUT_LOCATION);
        this.styleMapFactory = new StyleMapFactory();
        this.modifiedViewName = (String)aContext.getConfigParameterValue(OUTPUT_VIEW);
        this.modifiedViewName = StringUtils.isBlank(this.modifiedViewName) ? DEFAULT_MODIFIED_VIEW : this.modifiedViewName;
    }

    public void process(JCas cas) throws AnalysisEngineProcessException {
        block12: {
            try {
                File outputFile;
                String viewName = cas.getViewName();
                if (viewName == null) {
                    cas = cas.getView("_InitialView");
                }
                JCas modifiedView = null;
                Iterator viewIterator = cas.getViewIterator();
                while (viewIterator.hasNext()) {
                    JCas each = (JCas)viewIterator.next();
                    if (!each.getViewName().equals(this.modifiedViewName)) continue;
                    modifiedView = each;
                    break;
                }
                if (modifiedView == null) {
                    try {
                        modifiedView = cas.createView(this.modifiedViewName);
                    }
                    catch (Exception e) {
                        modifiedView = cas.getView(this.modifiedViewName);
                    }
                } else {
                    modifiedView = cas.getView(this.modifiedViewName);
                }
                String locate = RutaEngine.locate(this.styleMapLocation, this.descriptorPaths, ".xml", true);
                try {
                    String modifiedDocument = this.getModifiedDocument(cas, locate);
                    modifiedView.setDocumentText(modifiedDocument);
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                String documentText = modifiedView.getDocumentText();
                if (documentText == null || (outputFile = this.getOutputFile(cas.getCas())) == null) break block12;
                try {
                    FileUtils.saveString2File((String)documentText, (File)outputFile);
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    private File getOutputFile(CAS cas) {
        FSIterator sdiit;
        if (StringUtils.isBlank(this.outputLocation)) {
            return null;
        }
        Type sdiType = cas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
        String filename = "output.modified.html";
        File file = new File(this.outputLocation, filename);
        if (sdiType != null && (sdiit = cas.getAnnotationIndex(sdiType).iterator()).isValid()) {
            Feature uriFeature;
            AnnotationFS annotationFS = (AnnotationFS)sdiit.get();
            String stringValue = annotationFS.getStringValue(uriFeature = sdiType.getFeatureByBaseName("uri"));
            File f = new File(stringValue);
            String name = f.getName();
            if (!name.endsWith(".modified.html")) {
                name = name + ".modified.html";
            }
            file = new File(this.outputLocation, name);
        }
        return file;
    }

    private String getModifiedDocument(JCas cas, String styleMapLocation) {
        String startTag = "<span style='background:&bgcolor'>";
        String endTag = "</span>";
        Map<String, StyleMapEntry> styleMap = this.styleMapFactory.parseStyleMapDOM(styleMapLocation);
        ArrayList<Type> coloredTypes = new ArrayList();
        if (styleMap != null) {
            coloredTypes = this.getColoredTypes(cas, styleMap);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        FSIterator iterator = cas.getAnnotationIndex(RutaBasic.type).iterator();
        while (iterator.isValid()) {
            RutaBasic each = (RutaBasic)iterator.get();
            String replace = each.getReplacement() == null ? each.getCoveredText() : each.getReplacement();
            Type type = this.getColorType(each, coloredTypes, cas);
            if (type != null && !"".equals(replace)) {
                StyleMapEntry entry = styleMap.get(type.getName());
                String backgroundColor = "#" + Integer.toHexString(entry.getBackground().getRGB()).substring(2);
                String newStartTag = startTag.replaceAll("&bgcolor", backgroundColor);
                tokens.add(newStartTag);
                tokens.add(replace);
                tokens.add(endTag);
            } else {
                tokens.add(replace);
            }
            iterator.moveToNext();
        }
        StringBuilder sb = new StringBuilder();
        for (String string : tokens) {
            sb.append(string);
        }
        return sb.toString();
    }

    private Type getColorType(RutaBasic basic, List<Type> coloredTypes, JCas cas) {
        if (coloredTypes.isEmpty()) {
            return null;
        }
        ArrayList<Type> colorTypes = new ArrayList<Type>();
        for (Type each : coloredTypes) {
            if (!cas.getTypeSystem().subsumes(each, basic.getType()) && !basic.isPartOf(each)) continue;
            colorTypes.add(each);
        }
        Type best = null;
        if (!colorTypes.isEmpty() && colorTypes.size() == 1) {
            best = (Type)colorTypes.get(0);
        }
        return best;
    }

    private List<Type> getColoredTypes(JCas cas, Map<String, StyleMapEntry> styleMap) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (String string : styleMap.keySet()) {
            Type type;
            if (string == null || (type = cas.getTypeSystem().getType(string)) == null) continue;
            result.add(type);
        }
        Collections.sort(result, new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }
        });
        return result;
    }
}

