/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.constraint;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.type.RutaBasic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTypeConstraint
implements FSTypeConstraint {
    private static final long serialVersionUID = 1115953538613617791L;
    private final FSTypeConstraint constraint;
    private final Collection<Type> types;

    public BasicTypeConstraint(FSTypeConstraint constraint, Collection<Type> types) {
        this.constraint = constraint;
        this.types = types;
    }

    public BasicTypeConstraint(FSTypeConstraint constraint, Type type) {
        this.constraint = constraint;
        if (type != null) {
            this.types = new ArrayList<Type>();
            this.types.add(type);
        } else {
            this.types = null;
        }
    }

    public void add(Type type) {
        this.constraint.add(type);
    }

    public boolean match(FeatureStructure fs) {
        boolean result;
        block4: {
            RutaBasic tmb;
            if (fs instanceof RutaBasic && (tmb = (RutaBasic)fs).getBeginMap().isEmpty() && tmb.getEndMap().isEmpty()) {
                return true;
            }
            if (this.constraint.match(fs)) {
                return true;
            }
            result = false;
            if (!(fs instanceof RutaBasic)) break block4;
            RutaBasic tmb2 = (RutaBasic)fs;
            if (this.types != null) {
                for (Type each : this.types) {
                    if (result |= tmb2.isPartOf(each) || tmb2.beginsWith(each) || tmb2.endsWith(each)) break;
                }
            }
        }
        return result;
    }

    public String toString() {
        return "(BASIC " + this.constraint.toString() + " with " + this.types + ")";
    }

    public void add(String type) {
        this.constraint.add(type);
    }
}

