/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class InListCondition
extends TerminalRutaCondition {
    private BooleanExpression relative;
    private final NumberExpression distance;
    private WordListExpression listExpr;
    private StringListExpression stringList;

    public InListCondition(WordListExpression listExpr, NumberExpression distance, BooleanExpression relative) {
        this.listExpr = listExpr;
        this.distance = distance;
        this.relative = relative;
    }

    public InListCondition(StringListExpression list, NumberExpression distance, BooleanExpression relative) {
        this.distance = distance;
        this.relative = relative;
        this.stringList = list;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String coveredText = annotation.getCoveredText();
        if (this.stringList == null) {
            RutaWordList wordList = this.listExpr.getList(element.getParent());
            return new EvaluatedCondition(this, wordList.contains(coveredText, false, 0, null, 0, true));
        }
        List sList = this.stringList.getList(element.getParent());
        boolean contains = sList.contains(coveredText);
        return new EvaluatedCondition(this, contains);
    }

    public BooleanExpression getRelative() {
        return this.relative;
    }

    public NumberExpression getDistance() {
        return this.distance;
    }

    public WordListExpression getListExpression() {
        return this.listExpr;
    }

    public StringListExpression getStringList() {
        return this.stringList;
    }
}

