/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.list.BooleanListExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.NumberListExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ContainsCondition
extends TypeSentiveCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final BooleanExpression percent;
    private RutaExpression arg;
    private ListExpression argList;

    public ContainsCondition(TypeExpression type, NumberExpression min, NumberExpression max, BooleanExpression percent) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(1) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.percent = percent == null ? new SimpleBooleanExpression(false) : percent;
    }

    public ContainsCondition(ListExpression list, RutaExpression a, NumberExpression min, NumberExpression max, BooleanExpression percent) {
        super((TypeExpression)null);
        this.min = min == null ? new SimpleNumberExpression(1) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.percent = percent == null ? new SimpleBooleanExpression(false) : percent;
        this.argList = list;
        this.arg = a;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        int basicCount = 0;
        int anchorCount = 0;
        int totalCount = 0;
        if (this.type != null) {
            if (annotation != null) {
                List<RutaBasic> annotations = stream.getBasicsInWindow(annotation);
                for (RutaBasic each : annotations) {
                    ++totalCount;
                    Type t = this.type.getType(element.getParent());
                    if (each.beginsWith(t) || stream.getCas().getTypeSystem().subsumes(t, each.getType())) {
                        ++anchorCount;
                        ++basicCount;
                        continue;
                    }
                    if (!each.isPartOf(t)) continue;
                    ++basicCount;
                }
            }
        } else {
            StringExpression e;
            totalCount = this.argList.getList(element.getParent()).size();
            if (this.arg instanceof BooleanExpression && this.argList instanceof BooleanListExpression) {
                e = (BooleanExpression)this.arg;
                BooleanListExpression le = (BooleanListExpression)this.argList;
                boolean v = ((BooleanExpression)e).getBooleanValue(element.getParent());
                ArrayList l = new ArrayList(le.getList(element.getParent()));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.arg instanceof NumberExpression && this.argList instanceof NumberListExpression) {
                e = (NumberExpression)this.arg;
                NumberListExpression le = (NumberListExpression)this.argList;
                Double v = ((NumberExpression)e).getDoubleValue(element.getParent());
                ArrayList l = new ArrayList(le.getList(element.getParent()));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.arg instanceof StringExpression && this.argList instanceof StringListExpression) {
                e = (StringExpression)this.arg;
                StringListExpression le = (StringListExpression)this.argList;
                String v = e.getStringValue(element.getParent());
                ArrayList l = new ArrayList(le.getList(element.getParent()));
                while (l.remove(v)) {
                    ++basicCount;
                }
            } else if (this.arg instanceof TypeExpression && this.argList instanceof TypeListExpression) {
                e = (TypeExpression)this.arg;
                TypeListExpression le = (TypeListExpression)this.argList;
                Type v = ((TypeExpression)e).getType(element.getParent());
                ArrayList l = new ArrayList(le.getList(element.getParent()));
                while (l.remove(v)) {
                    ++basicCount;
                }
            }
            anchorCount = basicCount;
        }
        if (this.percent.getBooleanValue(element.getParent())) {
            double percentValue = 0.0;
            if (totalCount != 0) {
                percentValue = (double)basicCount / (double)totalCount * 100.0;
            }
            boolean value = percentValue >= this.min.getDoubleValue(element.getParent()) && percentValue <= this.max.getDoubleValue(element.getParent());
            return new EvaluatedCondition(this, value);
        }
        boolean value = anchorCount >= this.min.getIntegerValue(element.getParent()) && anchorCount <= this.max.getIntegerValue(element.getParent());
        return new EvaluatedCondition(this, value);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public BooleanExpression getPercent() {
        return this.percent;
    }

    public RutaExpression getArg() {
        return this.arg;
    }

    public ListExpression getArgList() {
        return this.argList;
    }
}

