/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.utils.UIMAUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructureAction
extends AbstractRutaAction {
    protected void fillFeatures(TOP structure, Map<StringExpression, RutaExpression> features, AnnotationFS matchedAnnotation, RuleElement element, RutaStream stream) {
        HashMap<String, RutaExpression> map = new HashMap<String, RutaExpression>();
        for (Map.Entry<StringExpression, RutaExpression> each : features.entrySet()) {
            String value = each.getKey().getStringValue(element.getParent());
            map.put(value, each.getValue());
        }
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        JCas jcas = stream.getJCas();
        List featuresList = structure.getType().getFeatures();
        for (int i = 0; i < featuresList.size(); ++i) {
            AnnotationFS annotation;
            List<AnnotationFS> annotationsInWindow;
            TypeExpression type;
            Feature targetFeature = (Feature)featuresList.get(i);
            String name = targetFeature.getName();
            String shortFName = name.substring(name.indexOf(":") + 1, name.length());
            Object valueObject = map.get(shortFName);
            Type range = targetFeature.getRange();
            if (valueObject == null) continue;
            if (valueObject instanceof TypeExpression && range.getName().equals("uima.cas.String")) {
                type = (TypeExpression)valueObject;
                annotationsInWindow = stream.getAnnotationsInWindow(matchedAnnotation, type.getType(element.getParent()));
                if (annotationsInWindow == null || annotationsInWindow.isEmpty()) continue;
                annotation = annotationsInWindow.get(0);
                structure.setStringValue(targetFeature, annotation.getCoveredText());
                continue;
            }
            if (valueObject instanceof StringExpression && range.getName().equals("uima.cas.String")) {
                structure.setStringValue(targetFeature, ((StringExpression)valueObject).getStringValue(element.getParent()));
                continue;
            }
            if (valueObject instanceof NumberExpression) {
                if (range.getName().equals("uima.cas.Integer")) {
                    structure.setIntValue(targetFeature, ((NumberExpression)valueObject).getIntegerValue(element.getParent()));
                    continue;
                }
                if (range.getName().equals("uima.cas.Double")) {
                    structure.setDoubleValue(targetFeature, ((NumberExpression)valueObject).getDoubleValue(element.getParent()));
                    continue;
                }
                if (range.getName().equals("uima.cas.Float")) {
                    structure.setFloatValue(targetFeature, ((NumberExpression)valueObject).getFloatValue(element.getParent()));
                    continue;
                }
                if (range.getName().equals("uima.cas.Byte")) {
                    structure.setByteValue(targetFeature, (byte)((NumberExpression)valueObject).getIntegerValue(element.getParent()));
                    continue;
                }
                if (range.getName().equals("uima.cas.Short")) {
                    structure.setShortValue(targetFeature, (short)((NumberExpression)valueObject).getIntegerValue(element.getParent()));
                    continue;
                }
                if (!range.getName().equals("uima.cas.Long")) continue;
                structure.setLongValue(targetFeature, (long)((NumberExpression)valueObject).getIntegerValue(element.getParent()));
                continue;
            }
            if (valueObject instanceof BooleanExpression && range.getName().equals("uima.cas.Boolean")) {
                structure.setBooleanValue(targetFeature, ((BooleanExpression)valueObject).getBooleanValue(element.getParent()));
                continue;
            }
            if (!(valueObject instanceof TypeExpression)) continue;
            type = (TypeExpression)valueObject;
            annotationsInWindow = stream.getAnnotationsInWindow(matchedAnnotation, type.getType(element.getParent()));
            if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                structure.setFeatureValue(targetFeature, (FeatureStructure)UIMAUtils.toFSArray(jcas, annotationsInWindow));
                continue;
            }
            if (!typeSystem.subsumes(range, type.getType(element.getParent())) || annotationsInWindow.isEmpty()) continue;
            annotation = annotationsInWindow.get(0);
            structure.setFeatureValue(targetFeature, (FeatureStructure)annotation);
        }
    }
}

