/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.util.Map;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValueEncoder;

public class SelectModelRenderer
implements SelectModelVisitor {
    private final MarkupWriter writer;
    private final ValueEncoder encoder;
    private final boolean raw;
    private int optgroupIdx = -1;
    private boolean inOptgroup = false;

    public SelectModelRenderer(MarkupWriter writer, ValueEncoder encoder, boolean raw) {
        this.writer = writer;
        this.encoder = encoder;
        this.raw = raw;
    }

    @Override
    public void beginOptionGroup(OptionGroupModel groupModel) {
        ++this.optgroupIdx;
        this.inOptgroup = true;
        this.writer.element("optgroup", "label", groupModel.getLabel());
        this.writeDisabled(groupModel.isDisabled());
        this.writeAttributes(groupModel.getAttributes());
    }

    @Override
    public void endOptionGroup(OptionGroupModel groupModel) {
        this.inOptgroup = false;
        this.writer.end();
    }

    @Override
    public void option(OptionModel optionModel) {
        Object optionValue = optionModel.getValue();
        String clientValue = this.encoder.toClient(optionValue);
        this.writer.element("option", "value", clientValue);
        if (this.inOptgroup && this.optgroupIdx > -1) {
            this.writer.attributes("data-optgroup-idx", this.optgroupIdx);
        }
        if (this.isOptionSelected(optionModel, clientValue)) {
            this.writer.attributes("selected", "selected");
        }
        this.writeDisabled(optionModel.isDisabled());
        this.writeAttributes(optionModel.getAttributes());
        if (this.raw) {
            this.writer.writeRaw(optionModel.getLabel());
        } else {
            this.writer.write(optionModel.getLabel());
        }
        this.writer.end();
    }

    private void writeDisabled(boolean disabled) {
        if (disabled) {
            this.writer.attributes("disabled", "disabled");
        }
    }

    private void writeAttributes(Map<String, String> attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            this.writer.attributes(e.getKey(), e.getValue());
        }
    }

    protected boolean isOptionSelected(OptionModel optionModel, String clientValue) {
        return false;
    }
}

