/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import java.util.Set;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.ModuleInitsManager;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.ModuleConfigurationCallback;
import org.apache.tapestry5.services.javascript.ModuleManager;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class DocumentLinkerImpl
implements DocumentLinker {
    private static final Set<String> HTML_MIME_TYPES = CollectionFactory.newSet((Object[])new String[]{"text/html", "application/xml+xhtml"});
    private final List<String> coreLibraryURLs = CollectionFactory.newList();
    private final List<String> libraryURLs = CollectionFactory.newList();
    private final ModuleInitsManager initsManager = new ModuleInitsManager();
    private final List<ModuleConfigurationCallback> moduleConfigurationCallbacks = CollectionFactory.newList();
    private final List<StylesheetLink> includedStylesheets = CollectionFactory.newList();
    private final ModuleManager moduleManager;
    private final boolean omitGeneratorMetaTag;
    private final boolean enablePageloadingMask;
    private final String tapestryBanner;
    private boolean hasScriptsOrInitializations;

    public DocumentLinkerImpl(ModuleManager moduleManager, boolean omitGeneratorMetaTag, boolean enablePageloadingMask, String tapestryVersion) {
        this.moduleManager = moduleManager;
        this.omitGeneratorMetaTag = omitGeneratorMetaTag;
        this.enablePageloadingMask = enablePageloadingMask;
        this.tapestryBanner = "Apache Tapestry Framework (version " + tapestryVersion + ')';
    }

    @Override
    public void addStylesheetLink(StylesheetLink sheet) {
        this.includedStylesheets.add(sheet);
    }

    @Override
    public void addCoreLibrary(String libraryURL) {
        this.coreLibraryURLs.add(libraryURL);
        this.hasScriptsOrInitializations = true;
    }

    @Override
    public void addLibrary(String libraryURL) {
        this.libraryURLs.add(libraryURL);
        this.hasScriptsOrInitializations = true;
    }

    @Override
    public void addScript(InitializationPriority priority, String script) {
        this.addInitialization(priority, "t5/core/pageinit", "evalJavaScript", new JSONArray().put((Object)script));
    }

    @Override
    public void addInitialization(InitializationPriority priority, String moduleName, String functionName, JSONArray arguments) {
        this.initsManager.addInitialization(priority, moduleName, functionName, arguments);
        this.hasScriptsOrInitializations = true;
    }

    public void updateDocument(Document document) {
        Element root = document.getRootElement();
        if (root == null) {
            return;
        }
        String mimeType = document.getMimeType();
        if (mimeType != null && !HTML_MIME_TYPES.contains(mimeType)) {
            return;
        }
        this.addStylesheetsToHead(root, this.includedStylesheets);
        boolean isHtmlRoot = root.getName().equals("html");
        if (!this.omitGeneratorMetaTag && isHtmlRoot) {
            Element head = this.findOrCreateElement(root, "head", true);
            Element existingMeta = head.find("meta");
            DocumentLinkerImpl.addElementBefore(head, existingMeta, "meta", "name", "generator", "content", this.tapestryBanner);
        }
        this.addScriptElements(root);
    }

    private static Element addElementBefore(Element container, Element insertionPoint, String name, String ... namesAndValues) {
        if (insertionPoint == null) {
            return container.element(name, namesAndValues);
        }
        return insertionPoint.elementBefore(name, namesAndValues);
    }

    private void addScriptElements(Element root) {
        Element body;
        String rootElementName = root.getName();
        Element element = body = rootElementName.equals("html") ? this.findOrCreateElement(root, "body", false) : null;
        if (body != null) {
            body.attribute("data-page-initialized", Boolean.toString(!this.hasScriptsOrInitializations));
        }
        if (!this.hasScriptsOrInitializations) {
            return;
        }
        if (!rootElementName.equals("html")) {
            throw new RuntimeException(String.format("The root element of the rendered document was <%s>, not <html>. A root element of <html> is needed when linking JavaScript and stylesheet resources.", rootElementName));
        }
        this.addContentToBody(body);
    }

    private Element findOrCreateElement(Element root, String childElement, boolean atTop) {
        Element container = root.find(childElement);
        if (container == null) {
            container = atTop ? root.elementAt(0, childElement, new String[0]) : root.element(childElement, new String[0]);
        }
        return container;
    }

    protected void addContentToBody(Element body) {
        if (this.enablePageloadingMask) {
            Element script = body.element("script", "type", "text/javascript");
            script.raw("document.write(\"<div class=\\\"pageloading-mask\\\"><div></div></div>\");");
            script.moveToTop(body);
        }
        this.moduleManager.writeConfiguration(body, this.moduleConfigurationCallbacks);
        for (String url : this.coreLibraryURLs) {
            body.element("script", "type", "text/javascript", "src", url);
        }
        this.moduleManager.writeInitialization(body, this.libraryURLs, this.initsManager.getSortedInits());
    }

    private static Element createTemporaryContainer(Element headElement, String existingElementName, String newElementName) {
        Element existingScript = headElement.find(existingElementName);
        return DocumentLinkerImpl.addElementBefore(headElement, existingScript, newElementName, new String[0]);
    }

    protected void addStylesheetsToHead(Element root, List<StylesheetLink> stylesheets) {
        int count = stylesheets.size();
        if (count == 0) {
            return;
        }
        String rootElementName = root.getName();
        if (!rootElementName.equals("html")) {
            return;
        }
        Element head = this.findOrCreateElement(root, "head", true);
        Element container = DocumentLinkerImpl.createTemporaryContainer(head, "style", "stylesheet-container");
        for (int i = 0; i < count; ++i) {
            stylesheets.get(i).add(container);
        }
        container.pop();
    }

    @Override
    public void addModuleConfigurationCallback(ModuleConfigurationCallback callback) {
        assert (callback != null);
        this.moduleConfigurationCallbacks.add(callback);
    }
}

