/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;

@Import(stylesheet={"${tapestry.datepicker}/css/datepicker.css"}, module={"t5/core/datefield"})
public class DateField
extends AbstractField {
    @Parameter(required=true, principal=true, autoconnect=true)
    private Date value;
    @Parameter(required=true, allowNull=false, defaultPrefix="literal")
    private DateFormat format;
    @Parameter(allowNull=false, defaultPrefix="literal", value="text")
    private String type;
    @Parameter(principal=true)
    private boolean lenient;
    @Parameter
    private boolean hideTextField;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(defaultPrefix="asset")
    private Asset icon;
    @Parameter(value="componentResources.messages")
    private Messages messages;
    @Inject
    private Locale locale;
    @Inject
    private DeprecationWarning deprecationWarning;
    @Inject
    @Symbol(value="tapestry.lenient-date-format")
    private boolean lenientDateFormatSymbolValue;
    private static final String RESULT = "result";
    private static final String ERROR = "error";
    private static final String INPUT_PARAMETER = "input";

    void pageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "icon");
    }

    DateFormat defaultFormat() {
        DateFormat shortDateFormat = DateFormat.getDateInstance(3, this.locale);
        if (shortDateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)shortDateFormat;
            String pattern = simpleDateFormat.toPattern();
            String revised = pattern.replaceAll("([^y])yy$", "$1yyyy");
            SimpleDateFormat revisedDateFormat = new SimpleDateFormat(revised);
            revisedDateFormat.setLenient(this.lenient);
            return revisedDateFormat;
        }
        return shortDateFormat;
    }

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    final boolean defaultLenient() {
        return this.lenientDateFormatSymbolValue;
    }

    JSONObject onParse(@RequestParameter(value="input") String input) {
        JSONObject response = new JSONObject();
        try {
            Date date = this.format.parse(input);
            response.put(RESULT, (Object)new SimpleDateFormat("yyyy-MM-dd").format(date));
        }
        catch (ParseException ex) {
            response.put(ERROR, (Object)ex.getMessage());
        }
        return response;
    }

    JSONObject onFormat(@RequestParameter(value="input") String input) throws ParseException {
        JSONObject response = new JSONObject();
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(input);
            response.put(RESULT, (Object)this.format.format(date));
        }
        catch (NumberFormatException ex) {
            response.put(ERROR, (Object)ex.getMessage());
        }
        return response;
    }

    void beginRender(MarkupWriter writer) {
        String value = this.validationTracker.getInput(this);
        if (value == null) {
            value = this.formatCurrentValue();
        }
        String clientId = this.getClientId();
        writer.element("div", "data-component-type", "core/DateField", "data-parse-url", this.resources.createEventLink("parse", new Object[0]).toString(), "data-format-url", this.resources.createEventLink("format", new Object[0]).toString());
        if (!this.hideTextField) {
            writer.attributes("class", "input-group");
        }
        Element field = writer.element(INPUT_PARAMETER, "type", this.type, "class", this.cssClass, "name", this.getControlName(), "id", clientId, "value", value);
        if (this.hideTextField) {
            field.attribute("class", "hide");
        }
        this.writeDisabled(writer);
        this.putPropertyNameIntoBeanValidationContext("value");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        writer.end();
        if (!this.hideTextField) {
            writer.element("span", "class", "input-group-btn");
        }
        writer.element("button", "type", "button", "class", "btn btn-default", "alt", "[Show]");
        writer.element("span", "class", "glyphicon glyphicon-calendar");
        writer.end();
        writer.end();
        if (!this.hideTextField) {
            writer.end();
        }
        writer.end();
    }

    private void writeDisabled(MarkupWriter writer) {
        if (this.isDisabled()) {
            writer.attributes("disabled", "disabled");
        }
    }

    private String formatCurrentValue() {
        if (this.value == null) {
            return "";
        }
        return this.format.format(this.value);
    }

    @Override
    protected void processSubmission(String controlName) {
        String value = this.request.getParameter(controlName);
        this.validationTracker.recordInput(this, value);
        Date parsedValue = null;
        try {
            if (InternalUtils.isNonBlank((String)value)) {
                parsedValue = this.format.parse(value);
            }
        }
        catch (ParseException ex) {
            this.validationTracker.recordError(this, this.messages.format("core-date-value-not-parseable", new Object[]{value}));
            return;
        }
        this.putPropertyNameIntoBeanValidationContext("value");
        try {
            this.fieldValidationSupport.validate(parsedValue, this.resources, this.validate);
            this.value = parsedValue;
        }
        catch (ValidationException ex) {
            this.validationTracker.recordError(this, ex.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void injectResources(ComponentResources resources) {
        this.resources = resources;
    }

    @Override
    public boolean isRequired() {
        return this.validate.isRequired();
    }
}

