/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.versionmigrator.internal;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.versionmigrator.ClassRefactor;
import org.apache.tapestry5.versionmigrator.FileRefactorCommitParser;

public class PackageChangeRefactorCommitParser
implements FileRefactorCommitParser {
    public static final String EXAMPLE = "commons/src/main/java/org/apache/tapestry5/{ioc => commons}/Messages.java (98%)";
    private static final Pattern PATTERN = Pattern.compile("([^/]*)/(.*)" + Pattern.quote("{") + "(.*)\\s=>\\s(.*)" + Pattern.quote("}/") + "([^\\.]*).*");

    @Override
    public Optional<ClassRefactor> apply(String line) {
        Matcher matcher = PATTERN.matcher(line);
        ClassRefactor move = null;
        if (matcher.matches()) {
            String newPackageNameSuffix = matcher.group(4);
            String oldPackageNameSuffix = matcher.group(3);
            String rootPackageName = matcher.group(2).replace("src/main/java/", "").replace("/", ".");
            String className = matcher.group(5);
            String newClassName = FileRefactorCommitParser.buildClassName(rootPackageName, newPackageNameSuffix, className);
            String oldClassName = FileRefactorCommitParser.buildClassName(rootPackageName, oldPackageNameSuffix, className);
            String artifactName = matcher.group(1);
            move = new ClassRefactor(newClassName, oldClassName, artifactName, artifactName);
        }
        return Optional.ofNullable(move);
    }
}

