/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.beanmodel;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.beanmodel.internal.services.BeanModelSourceImpl;
import org.apache.tapestry5.beanmodel.internal.services.PropertyAccessImpl;
import org.apache.tapestry5.beanmodel.internal.services.PropertyConduitSourceImpl;
import org.apache.tapestry5.beanmodel.services.BeanModelSource;
import org.apache.tapestry5.beanmodel.services.PlasticProxyFactoryImpl;
import org.apache.tapestry5.beanmodel.services.PropertyConduitSource;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.commons.internal.BasicDataTypeAnalyzers;
import org.apache.tapestry5.commons.internal.BasicTypeCoercions;
import org.apache.tapestry5.commons.internal.services.StringInterner;
import org.apache.tapestry5.commons.internal.services.StringInternerImpl;
import org.apache.tapestry5.commons.internal.services.TypeCoercerImpl;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.CoercionTuple;
import org.apache.tapestry5.commons.services.DataTypeAnalyzer;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.services.PropertyAccess;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.slf4j.LoggerFactory;

public class BeanModelSourceBuilder {
    private TypeCoercer typeCoercer;
    private PropertyAccess propertyAccess;
    private PropertyConduitSource propertyConduitSource;
    private PlasticProxyFactory plasticProxyFactory;
    private DataTypeAnalyzer dataTypeAnalyzer;
    private ObjectLocator objectLocator;
    private StringInterner stringInterner;

    public BeanModelSource build() {
        if (this.typeCoercer == null) {
            this.createTypeCoercer();
        }
        if (this.propertyAccess == null) {
            this.propertyAccess = new PropertyAccessImpl();
        }
        if (this.dataTypeAnalyzer == null) {
            this.dataTypeAnalyzer = BasicDataTypeAnalyzers.createDefaultDataTypeAnalyzer();
        }
        if (this.stringInterner == null) {
            this.stringInterner = new StringInternerImpl();
        }
        if (this.plasticProxyFactory == null) {
            this.plasticProxyFactory = new PlasticProxyFactoryImpl(this.getClass().getClassLoader(), LoggerFactory.getLogger(PlasticProxyFactory.class));
        }
        if (this.propertyConduitSource == null) {
            this.propertyConduitSource = new PropertyConduitSourceImpl(this.propertyAccess, this.plasticProxyFactory, this.typeCoercer, this.stringInterner);
        }
        if (this.objectLocator == null) {
            this.objectLocator = new AutobuildOnlyObjectLocator();
        }
        return new BeanModelSourceImpl(this.typeCoercer, this.propertyAccess, this.propertyConduitSource, this.plasticProxyFactory, this.dataTypeAnalyzer, this.objectLocator);
    }

    public BeanModelSourceBuilder setTypeCoercer(TypeCoercer typeCoercer) {
        this.typeCoercer = typeCoercer;
        return this;
    }

    public BeanModelSourceBuilder setPropertyAccess(PropertyAccess propertyAccess) {
        this.propertyAccess = propertyAccess;
        return this;
    }

    public BeanModelSourceBuilder setPropertyConduitSource(PropertyConduitSource propertyConduitSource) {
        this.propertyConduitSource = propertyConduitSource;
        return this;
    }

    public BeanModelSourceBuilder setPlasticProxyFactory(PlasticProxyFactory plasticProxyFactory) {
        this.plasticProxyFactory = plasticProxyFactory;
        return this;
    }

    public BeanModelSourceBuilder setDataTypeAnalyzer(DataTypeAnalyzer dataTypeAnalyzer) {
        this.dataTypeAnalyzer = dataTypeAnalyzer;
        return this;
    }

    public BeanModelSourceBuilder setObjectLocator(ObjectLocator objectLocator) {
        this.objectLocator = objectLocator;
        return this;
    }

    public BeanModelSourceBuilder setStringInterner(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
        return this;
    }

    private void createTypeCoercer() {
        CoercionTupleConfiguration configuration = new CoercionTupleConfiguration();
        BasicTypeCoercions.provideBasicTypeCoercions((MappedConfiguration)configuration);
        BasicTypeCoercions.provideJSR310TypeCoercions((MappedConfiguration)configuration);
        this.typeCoercer = new TypeCoercerImpl(configuration.getTuples());
    }

    private static final class AutobuildOnlyObjectLocator
    implements ObjectLocator {
        private AutobuildOnlyObjectLocator() {
        }

        public <T> T getService(String serviceId, Class<T> serviceInterface) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getService(Class<T> serviceInterface) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getService(Class<T> serviceInterface, Class<? extends Annotation> ... markerTypes) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T autobuild(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new TapestryException("Couldn't instantiate class " + clazz.getName(), (Throwable)e);
            }
        }

        public <T> T autobuild(String description, Class<T> clazz) {
            return this.autobuild(clazz);
        }

        public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass) {
            throw new RuntimeException("Not implemented");
        }
    }

    private static final class CoercionTupleConfiguration
    implements MappedConfiguration<CoercionTuple.Key, CoercionTuple> {
        private final Map<CoercionTuple.Key, CoercionTuple> tuples = new HashMap<CoercionTuple.Key, CoercionTuple>();

        private CoercionTupleConfiguration() {
        }

        public void add(CoercionTuple.Key key, CoercionTuple tuple) {
            this.tuples.put(key, tuple);
        }

        public void addInstance(CoercionTuple.Key key, Class<? extends CoercionTuple> clazz) {
            throw new RuntimeException("Not implemented");
        }

        public Map<CoercionTuple.Key, CoercionTuple> getTuples() {
            return this.tuples;
        }

        public void override(CoercionTuple.Key key, CoercionTuple value) {
            throw new RuntimeException("Not implemented");
        }

        public void overrideInstance(CoercionTuple.Key key, Class<? extends CoercionTuple> clazz) {
            throw new RuntimeException("Not implemented");
        }
    }
}

