/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.test.json.JsonAssert;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.json.JsonComparison;
import org.springframework.test.json.JsonContent;
import org.springframework.test.json.JsonLoader;
import org.springframework.test.json.JsonPathValueAssert;
import org.springframework.util.Assert;

public abstract class AbstractJsonContentAssert<SELF extends AbstractJsonContentAssert<SELF>>
extends AbstractObjectAssert<SELF, JsonContent> {
    private static final Failures failures = Failures.instance();
    @Nullable
    private final HttpMessageContentConverter contentConverter;
    @Nullable
    private Class<?> resourceLoadClass;
    @Nullable
    private Charset charset;
    private JsonLoader jsonLoader;

    protected AbstractJsonContentAssert(@Nullable JsonContent actual, Class<?> selfType) {
        super((Object)actual, selfType);
        this.contentConverter = actual != null ? actual.getContentConverter() : null;
        this.jsonLoader = new JsonLoader(null, null);
        this.as("JSON content", new Object[0]);
    }

    public <T> AbstractObjectAssert<?, T> convertTo(Class<T> target) {
        this.isNotNull();
        T value = this.convertToTargetType(target);
        return Assertions.assertThat(value);
    }

    public <ASSERT extends AbstractAssert<?, ?>> ASSERT convertTo(AssertFactory<?, ASSERT> assertFactory) {
        this.isNotNull();
        return (ASSERT)((AbstractAssert)assertFactory.createAssert(this::convertToTargetType));
    }

    private <T> T convertToTargetType(Type targetType) {
        String json = ((JsonContent)this.actual).getJson();
        if (this.contentConverter == null) {
            throw new IllegalStateException("No JSON message converter available to convert %s".formatted(json));
        }
        try {
            return this.contentConverter.convert(this.fromJson(json), MediaType.APPLICATION_JSON, ResolvableType.forType((Type)targetType));
        }
        catch (Exception ex) {
            throw this.failure(new ValueProcessingFailed(json, "To convert successfully to:%n  %s%nBut it failed:%n  %s%n".formatted(targetType.getTypeName(), ex.getMessage())));
        }
    }

    private HttpInputMessage fromJson(String json) {
        MockHttpInputMessage inputMessage = new MockHttpInputMessage(json.getBytes(StandardCharsets.UTF_8));
        inputMessage.getHeaders().add("Content-Type", "application/json");
        return inputMessage;
    }

    public JsonPathValueAssert extractingPath(String path) {
        Object value = new JsonPathValue(path).getValue();
        return new JsonPathValueAssert(value, path, this.contentConverter);
    }

    public SELF hasPathSatisfying(String path, Consumer<AssertProvider<JsonPathValueAssert>> valueRequirements) {
        Object value = new JsonPathValue(path).assertHasPath();
        JsonPathValueAssert valueAssert = new JsonPathValueAssert(value, path, this.contentConverter);
        valueRequirements.accept((AssertProvider<JsonPathValueAssert>)((AssertProvider)() -> valueAssert));
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF hasPath(String path) {
        new JsonPathValue(path).assertHasPath();
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF doesNotHavePath(String path) {
        new JsonPathValue(path).assertDoesNotHavePath();
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF isEqualTo(@Nullable CharSequence expected) {
        return this.isEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF isEqualTo(@Nullable CharSequence expected, JsonCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMatch(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isEqualTo(Resource expected, JsonCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMatch(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isEqualTo(@Nullable CharSequence expected, JsonComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMatch(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isEqualTo(Resource expected, JsonComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMatch(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isLenientlyEqualTo(@Nullable CharSequence expected) {
        return this.isEqualTo(expected, JsonCompareMode.LENIENT);
    }

    public SELF isLenientlyEqualTo(Resource expected) {
        return this.isEqualTo(expected, JsonCompareMode.LENIENT);
    }

    public SELF isStrictlyEqualTo(@Nullable CharSequence expected) {
        return this.isEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF isStrictlyEqualTo(Resource expected) {
        return this.isEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF isNotEqualTo(@Nullable CharSequence expected) {
        return this.isNotEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF isNotEqualTo(@Nullable CharSequence expected, JsonCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMismatch(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isNotEqualTo(Resource expected, JsonCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMismatch(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isNotEqualTo(@Nullable CharSequence expected, JsonComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMismatch(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isNotEqualTo(Resource expected, JsonComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertIsMismatch(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isNotLenientlyEqualTo(@Nullable CharSequence expected) {
        return this.isNotEqualTo(expected, JsonCompareMode.LENIENT);
    }

    public SELF isNotLenientlyEqualTo(Resource expected) {
        return this.isNotEqualTo(expected, JsonCompareMode.LENIENT);
    }

    public SELF isNotStrictlyEqualTo(@Nullable CharSequence expected) {
        return this.isNotEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF isNotStrictlyEqualTo(Resource expected) {
        return this.isNotEqualTo(expected, JsonCompareMode.STRICT);
    }

    public SELF withResourceLoadClass(@Nullable Class<?> resourceLoadClass) {
        this.resourceLoadClass = resourceLoadClass;
        this.jsonLoader = new JsonLoader(resourceLoadClass, this.charset);
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF withCharset(@Nullable Charset charset) {
        this.charset = charset;
        this.jsonLoader = new JsonLoader(this.resourceLoadClass, charset);
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    @Nullable
    private String toJsonString() {
        return this.actual != null ? ((JsonContent)this.actual).getJson() : null;
    }

    private String toNonNullJsonString() {
        String jsonString = this.toJsonString();
        ((AbstractStringAssert)Assertions.assertThat((String)jsonString).as("JSON content", new Object[0])).isNotNull();
        return jsonString;
    }

    private JsonComparison compare(@Nullable CharSequence expectedJson, JsonCompareMode compareMode) {
        return this.compare(expectedJson, JsonAssert.comparator(compareMode));
    }

    private JsonComparison compare(@Nullable CharSequence expectedJson, JsonComparator comparator) {
        return comparator.compare(expectedJson != null ? expectedJson.toString() : null, this.toJsonString());
    }

    private SELF assertIsMatch(JsonComparison result) {
        return this.assertComparison(result, JsonComparison.Result.MATCH);
    }

    private SELF assertIsMismatch(JsonComparison result) {
        return this.assertComparison(result, JsonComparison.Result.MISMATCH);
    }

    private SELF assertComparison(JsonComparison jsonComparison, JsonComparison.Result requiredResult) {
        if (jsonComparison.getResult() != requiredResult) {
            this.failWithMessage("JSON comparison failure: %s", new Object[]{jsonComparison.getMessage()});
        }
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    private AssertionError failure(BasicErrorMessageFactory errorMessageFactory) {
        throw failures.failure((AssertionInfo)this.info, (ErrorMessageFactory)errorMessageFactory);
    }

    private static final class ValueProcessingFailed
    extends BasicErrorMessageFactory {
        private ValueProcessingFailed(String actualToString, String errorMessage) {
            super("%nExpected:%n  %s%n%s".formatted(actualToString, errorMessage), new Object[0]);
        }
    }

    private class JsonPathValue {
        private final String path;
        private final String json;
        private final JsonPath jsonPath;

        JsonPathValue(String path) {
            Assert.hasText((String)path, (String)"'path' must not be null or empty");
            this.path = path;
            this.json = AbstractJsonContentAssert.this.toNonNullJsonString();
            this.jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
        }

        @Nullable
        Object assertHasPath() {
            return this.getValue();
        }

        void assertDoesNotHavePath() {
            try {
                this.read();
                throw AbstractJsonContentAssert.this.failure(new JsonPathNotExpected(this.json, this.path));
            }
            catch (PathNotFoundException pathNotFoundException) {
                return;
            }
        }

        @Nullable
        Object getValue() {
            try {
                return this.read();
            }
            catch (PathNotFoundException ex) {
                throw AbstractJsonContentAssert.this.failure(new JsonPathNotFound(this.json, this.path));
            }
        }

        @Nullable
        private Object read() {
            return this.jsonPath.read(this.json);
        }

        static final class JsonPathNotExpected
        extends BasicErrorMessageFactory {
            private JsonPathNotExpected(String actual, String path) {
                super("%nExpecting:%n  %s%nNot to match JSON path:%n  %s%n", new Object[]{actual, path});
            }
        }

        static final class JsonPathNotFound
        extends BasicErrorMessageFactory {
            private JsonPathNotFound(String actual, String path) {
                super("%nExpecting:%n  %s%nTo match JSON path:%n  %s%n", new Object[]{actual, path});
            }
        }
    }
}

