/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.java;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.NothingToCompileError;
import com.google.gxp.compiler.base.BooleanType;
import com.google.gxp.compiler.base.BoundImplementsDeclaration;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.ClassImport;
import com.google.gxp.compiler.base.Constructor;
import com.google.gxp.compiler.base.ContentType;
import com.google.gxp.compiler.base.DefaultingImportVisitor;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.ImplementsVisitor;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.InstanceType;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.NativeImplementsDeclaration;
import com.google.gxp.compiler.base.NativeType;
import com.google.gxp.compiler.base.NullRoot;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.PackageImport;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.RootVisitor;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.TemplateType;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.base.Tree;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.base.UnboundImplementsDeclaration;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.codegen.BracesCodeGenerator;
import com.google.gxp.compiler.java.JavaUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class BaseJavaCodeGenerator<T extends Tree<Root>>
extends BracesCodeGenerator<T> {
    protected final String runtimeMessageSource;

    protected BaseJavaCodeGenerator(T tree, String runtimeMessageSource) {
        super(tree);
        this.runtimeMessageSource = runtimeMessageSource;
    }

    @Override
    public void generateCode(final Appendable appendable, final AlertSink alertSink) throws IOException {
        alertSink.addAll(this.tree.getAlerts());
        this.root.acceptVisitor(new RootVisitor<Void>(){

            @Override
            public Void visitInterface(Interface iface) {
                BaseJavaCodeGenerator.this.validateFormalTypeParameters(alertSink, iface.getFormalTypeParameters());
                new InterfaceWorker(appendable, alertSink, iface).run();
                return null;
            }

            @Override
            public Void visitNullRoot(NullRoot nullRoot) {
                alertSink.add(new NothingToCompileError(nullRoot.getSourcePosition()));
                return null;
            }

            @Override
            public Void visitTemplate(Template template) {
                BaseJavaCodeGenerator.this.validateFormalTypeParameters(alertSink, template.getFormalTypeParameters());
                BaseJavaCodeGenerator.this.createTemplateWorker(appendable, alertSink, template, BaseJavaCodeGenerator.this.runtimeMessageSource).run();
                return null;
            }
        });
    }

    private void validateFormalTypeParameters(AlertSink alertSink, List<FormalTypeParameter> formalTypeParameters) {
        for (FormalTypeParameter formalTypeParameter : formalTypeParameters) {
            OutputLanguage.JAVA.validateName(alertSink, formalTypeParameter, formalTypeParameter.getName());
        }
    }

    protected abstract TemplateWorker createTemplateWorker(Appendable var1, AlertSink var2, Template var3, String var4);

    protected static abstract class TemplateWorker
    extends Worker {
        protected final Template template;
        protected Function<Parameter, String> parameterToAnnotatedCallParameter = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                StringBuilder sb = new StringBuilder();
                sb.append("final ");
                for (JavaAnnotation annotation : param.getJavaAnnotations()) {
                    sb.append(JavaUtil.validateAnnotation(TemplateWorker.this.alertSink, annotation));
                    sb.append(" ");
                }
                sb.append(TemplateWorker.this.toJavaType(param.getType()));
                sb.append(" ");
                sb.append(param.getPrimaryName());
                return sb.toString();
            }
        };
        private final ImplementsVisitor<String> javaNameImplementsVisitor = new ImplementsVisitor<String>(){

            @Override
            public String visitUnboundImplementsDeclaration(UnboundImplementsDeclaration uid) {
                throw new UnexpectedNodeException(uid);
            }

            @Override
            public String visitBoundImplementsDeclaration(BoundImplementsDeclaration bid) {
                return bid.getImplementable().getName().toString();
            }

            @Override
            public String visitNativeImplementsDeclaration(NativeImplementsDeclaration nid) {
                return TemplateWorker.this.toJavaType(nid.getNativeType());
            }
        };
        private final Function<ImplementsDeclaration, String> getInterfaceFromImplementsDeclaration = new Function<ImplementsDeclaration, String>(){

            @Override
            public String apply(ImplementsDeclaration implementsDeclaration) {
                return (String)implementsDeclaration.acceptImplementsVisitor(TemplateWorker.this.javaNameImplementsVisitor);
            }
        };
        private static final String GET_ARG_LIST_FORMAT = TemplateWorker.loadFormat("getArgList");

        protected TemplateWorker(Appendable appendable, AlertSink alertSink, Template template) {
            super(appendable, alertSink);
            this.template = Preconditions.checkNotNull(template);
        }

        public void run() {
            for (Parameter param : this.template.getAllParameters()) {
                OutputLanguage.JAVA.validateName(this.alertSink, param, param.getPrimaryName());
            }
            this.appendHeader(this.template);
            this.appendImports(this.template);
            this.appendLine();
            this.appendClass();
            this.appendLine();
            this.appendFooter();
        }

        protected String getFullClassName(TemplateName templateName) {
            return templateName == null ? null : templateName.toString();
        }

        protected abstract String getBaseClassName();

        protected abstract void appendClass();

        private void appendImplementsDeclaration(StringBuilder sb, List<ImplementsDeclaration> implementsDeclarations) {
            if (!implementsDeclarations.isEmpty()) {
                sb.append(" extends ");
                Join.join(sb, ", ", Iterables.transform(implementsDeclarations, this.getInterfaceFromImplementsDeclaration));
            }
        }

        protected abstract void appendWriteMethodBody();

        protected void appendWriteMethod() {
            this.appendLine(this.getWriteMethodSignature(true) + " {");
            this.appendWriteMethodBody();
            this.appendLine("}");
        }

        protected String getBaseName(String fullName) {
            String[] parts = fullName.split("\\.");
            return parts[parts.length - 1];
        }

        protected void appendGetGxpClosureMethod(boolean isStatic) {
            String javaType = this.template.getSchema().getJavaType();
            String tunnelingJavaType = "Tunneling" + this.getBaseName(javaType);
            if (isStatic) {
                this.appendLine();
                this.formatLine("private abstract static class %s", tunnelingJavaType);
                this.appendLine("    extends GxpTemplate.TunnelingGxpClosure");
                this.formatLine("    implements %s {", javaType);
                this.appendLine("}");
            }
            this.appendLine();
            this.appendLine(this.getGetGxpClosureMethodSignature(isStatic) + " {");
            this.formatLine("return new %s() {", tunnelingJavaType);
            StringBuilder sb = new StringBuilder("public void writeImpl(" + GXP_SIG + ")");
            TemplateWorker.appendJavaThrowsDeclaration(sb, this.template.getThrowsDeclarations());
            sb.append(" {");
            this.appendLine(sb);
            sb = new StringBuilder();
            sb.append(isStatic ? this.getFullClassName(this.template.getName()) : "Instance.this");
            sb.append(".write(gxp$out, gxp_context");
            for (Parameter param : isStatic ? this.template.getAllParameters() : this.template.getParameters()) {
                sb.append(", ");
                sb.append(param.getPrimaryName());
            }
            sb.append(");");
            this.appendLine(sb);
            this.appendLine("}");
            this.appendLine("};");
            this.appendLine("}");
        }

        protected void appendGetArgListMethod() {
            StringBuilder sb = new StringBuilder("private static final java.util.List<String> GXP$ARGLIST = ");
            ArrayList<String> parameterNames = Lists.newArrayList();
            for (Parameter param : this.template.getAllParameters()) {
                parameterNames.add(OutputLanguage.JAVA.toStringLiteral(param.getPrimaryName()));
            }
            if (parameterNames.isEmpty()) {
                sb.append("java.util.Collections.emptyList();");
            } else {
                sb.append("java.util.Collections.unmodifiableList(java.util.Arrays.asList(");
                Join.join(sb, ", ", parameterNames);
                sb.append("));");
            }
            this.appendLine();
            this.appendLine(sb);
            this.appendLine();
            this.appendLine(GET_ARG_LIST_FORMAT);
        }

        private String getWriteMethodSignature(boolean isStatic) {
            return this.getWriteMethodSignature(Access._public, isStatic, "write");
        }

        protected String getWriteMethodSignature(Access access, boolean isStatic, String methodName) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder(access.toString());
            if (isStatic) {
                sb.append(" static");
                if (!this.template.getFormalTypeParameters().isEmpty()) {
                    sb.append(" ");
                }
                this.appendJavaFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
            }
            sb.append(" void ");
            sb.append(methodName);
            sb.append("(" + GXP_SIG);
            for (Parameter param : params) {
                sb.append(", ");
                sb.append((String)this.parameterToCallName.apply(param));
            }
            sb.append(")");
            TemplateWorker.appendJavaThrowsDeclaration(sb, this.template.getThrowsDeclarations());
            return sb.toString();
        }

        private String getGetGxpClosureMethodSignature(boolean isStatic) {
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            StringBuilder sb = new StringBuilder("public");
            if (isStatic) {
                sb.append(" static");
                if (!this.template.getFormalTypeParameters().isEmpty()) {
                    sb.append(" ");
                }
                this.appendJavaFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
            }
            sb.append(" ");
            sb.append(this.template.getSchema().getJavaType());
            sb.append(" getGxpClosure(");
            Join.join(sb, ", ", Iterables.transform(params, this.parameterToCallName));
            sb.append(")");
            return sb.toString();
        }

        protected void appendInterface() {
            this.appendLine();
            this.appendLine("/**\n * Interface that defines a strategy for writing this GXP\n */");
            this.appendAnnotations(this.template.getJavaAnnotations(JavaAnnotation.Element.INTERFACE));
            StringBuilder sb = new StringBuilder("public interface Interface");
            this.appendJavaFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
            this.appendImplementsDeclaration(sb, this.template.getImplementsDeclarations());
            sb.append(" {");
            this.appendLine(sb);
            this.appendLine(this.getWriteMethodSignature(false) + ";");
            this.appendLine();
            this.appendLine(this.getGetGxpClosureMethodSignature(false) + ";");
            for (Parameter param : this.template.getParameters()) {
                if (param.getDefaultValue() == null) continue;
                this.appendLine();
                this.formatLine("%s %s();", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getDefaultMethodName(param));
            }
            for (Parameter param : this.template.getParameters()) {
                if (param.getConstructor() == null) continue;
                this.appendLine();
                this.formatLine("%s %s(String %s);", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getConstructorMethodName(param), param.getPrimaryName());
            }
            this.appendLine("}");
        }

        protected void appendInstance() {
            Constructor constructor = this.template.getConstructor();
            List<Parameter> cParams = constructor.getParameters();
            this.appendLine();
            this.appendLine("/**\n * Instantiable instance of this GXP\n */");
            this.appendAnnotations(this.template.getJavaAnnotations(JavaAnnotation.Element.INSTANCE));
            StringBuilder sb = new StringBuilder("public static class Instance");
            this.appendJavaFormalTypeParameters(sb, true, this.template.getFormalTypeParameters());
            sb.append(" implements Interface");
            this.appendJavaFormalTypeParameters(sb, false, this.template.getFormalTypeParameters());
            sb.append(" {");
            this.appendLine(sb);
            for (Parameter param : cParams) {
                this.formatLine("private final %s %s;", this.toJavaType(param.getType()), param.getPrimaryName());
            }
            this.appendLine();
            this.appendAnnotations(constructor.getJavaAnnotations());
            sb = new StringBuilder("public Instance(");
            Join.join(sb, ", ", Iterables.transform(cParams, this.parameterToAnnotatedCallParameter));
            sb.append(") {");
            this.appendLine(sb);
            for (Parameter param : cParams) {
                this.formatLine("this.%s = %s;", param.getPrimaryName(), param.getPrimaryName());
            }
            this.appendLine("}");
            this.appendLine();
            this.appendLine(this.getWriteMethodSignature(false) + " {");
            sb = new StringBuilder(this.getFullClassName(this.template.getName()));
            sb.append(".write(gxp$out, gxp_context");
            for (Parameter param : this.template.getAllParameters()) {
                sb.append(", ");
                sb.append((String)this.paramToCallName.apply(param));
            }
            sb.append(");");
            this.appendLine(sb);
            this.appendLine("}");
            this.appendGetGxpClosureMethod(false);
            for (Parameter param : this.template.getParameters()) {
                if (param.getDefaultValue() == null) continue;
                this.appendLine();
                this.formatLine("public %s %s() {", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getDefaultMethodName(param));
                this.formatLine("return %s.%s();", this.getFullClassName(this.template.getName()), BaseJavaCodeGenerator.getDefaultMethodName(param));
                this.appendLine("}");
            }
            for (Parameter param : this.template.getParameters()) {
                if (param.getConstructor() == null) continue;
                this.appendLine();
                this.formatLine("public %s %s(String %s) {", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getConstructorMethodName(param), param.getPrimaryName());
                this.formatLine("return %s.%s(%s);", this.getFullClassName(this.template.getName()), BaseJavaCodeGenerator.getConstructorMethodName(param), param.getPrimaryName());
                this.appendLine("}");
            }
            this.appendLine("}");
        }

        protected static enum Access {
            _public("public"),
            _private("private"),
            _protected("protected");

            private final String s;

            private Access(String s) {
                this.s = s;
            }

            public String toString() {
                return this.s;
            }
        }
    }

    protected static class InterfaceWorker
    extends Worker {
        protected final Interface iface;

        protected InterfaceWorker(Appendable appendable, AlertSink alertSink, Interface iface) {
            super(appendable, alertSink);
            this.iface = Preconditions.checkNotNull(iface);
        }

        public void run() {
            for (Parameter param : Iterables.filter(this.iface.getParameters(), Implementable.NOT_INSTANCE_PARAM)) {
                OutputLanguage.JAVA.validateName(this.alertSink, param, param.getPrimaryName());
            }
            this.appendHeader(this.iface);
            this.appendImports(this.iface);
            this.appendLine();
            this.appendInterface();
            this.appendLine();
            this.appendFooter();
        }

        @Override
        protected SourcePosition getDefaultSourcePosition() {
            return this.iface.getSourcePosition();
        }

        protected void appendInterface() {
            this.appendAnnotations(this.iface.getJavaAnnotations(JavaAnnotation.Element.INTERFACE));
            StringBuilder sb = new StringBuilder("public interface ");
            sb.append(this.getClassName(this.iface.getName()));
            this.appendJavaFormalTypeParameters(sb, true, this.iface.getFormalTypeParameters());
            sb.append(" {");
            this.appendLine(this.iface.getSourcePosition(), sb.toString());
            this.appendLine(this.getWriteMethodSignature());
            this.appendLine(this.getGetGxpClosureMethodSignature());
            this.appendGetDefaultMethods();
            this.appendConstructorMethods();
            this.appendLine("}");
        }

        private String getWriteMethodSignature() {
            StringBuilder sb = new StringBuilder("void write(");
            sb.append(GXP_SIG);
            for (Parameter param : Iterables.filter(this.iface.getParameters(), Implementable.NOT_INSTANCE_PARAM)) {
                sb.append(", ");
                sb.append((String)this.parameterToCallName.apply(param));
            }
            sb.append(")");
            InterfaceWorker.appendJavaThrowsDeclaration(sb, this.iface.getThrowsDeclarations());
            sb.append(";");
            return sb.toString();
        }

        private String getGetGxpClosureMethodSignature() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.iface.getSchema().getJavaType());
            sb.append(" getGxpClosure(");
            Join.join(sb, ", ", Iterables.transform(Iterables.filter(this.iface.getParameters(), Implementable.NOT_INSTANCE_PARAM), this.parameterToCallName));
            sb.append(");");
            return sb.toString();
        }

        private void appendGetDefaultMethods() {
            for (Parameter param : this.iface.getParameters()) {
                if (!param.hasDefaultFlag()) continue;
                this.formatLine(param.getSourcePosition(), "%s %s();", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getDefaultMethodName(param));
            }
        }

        private void appendConstructorMethods() {
            for (Parameter param : this.iface.getParameters()) {
                if (!param.hasConstructorFlag()) continue;
                this.formatLine(param.getSourcePosition(), "public %s %s(String %s);", this.toJavaType(param.getType()), BaseJavaCodeGenerator.getConstructorMethodName(param), param.getPrimaryName());
            }
        }
    }

    protected static abstract class Worker
    extends BracesCodeGenerator.Worker {
        private static final String HEADER_FORMAT = Worker.loadFormat("header");
        private final ImportVisitor<Void> IMPORT_VISITOR = new DefaultingImportVisitor<Void>(){

            @Override
            public Void defaultVisitImport(Import imp) {
                return null;
            }

            @Override
            public Void visitClassImport(ClassImport imp) {
                Worker.this.formatLine(imp.getSourcePosition(), "import %s;", new Object[]{imp.getClassName().toString()});
                return null;
            }

            @Override
            public Void visitPackageImport(PackageImport imp) {
                Worker.this.formatLine(imp.getSourcePosition(), "import %s.*;", new Object[]{imp.getPackageName()});
                return null;
            }
        };
        protected static final String GXP_OUT_VAR = "gxp$out";
        protected static final String GXP_CONTEXT_VAR = "gxp_context";
        protected static final String GXP_SIG = Join.join(", ", (Object)"final java.lang.Appendable gxp$out", "final com.google.gxp.base.GxpContext gxp_context");
        protected Function<Parameter, String> parameterToCallName = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                StringBuilder sb = new StringBuilder("final ");
                sb.append(Worker.this.toJavaType(param.getType()));
                sb.append(" ");
                sb.append(param.getPrimaryName());
                return sb.toString();
            }
        };

        protected Worker(Appendable appendable, AlertSink alertSink) {
            super(appendable, alertSink, new String[0]);
        }

        @Override
        protected void appendHeader(Root root) {
            super.appendHeader(root);
            TemplateName.FullyQualified name = root.getName();
            String sourceName = root.getSourcePosition().getSourceName();
            String packageName = name == null ? "" : name.getPackageName();
            this.formatLine((SourcePosition)null, HEADER_FORMAT, sourceName, packageName);
        }

        protected void appendImports(Root root) {
            for (String string : root.getSchema().getJavaImports()) {
                this.appendLine(root.getSourcePosition(), "import " + string + ";");
            }
            for (Import import_ : root.getImports()) {
                import_.acceptVisitor(this.IMPORT_VISITOR);
            }
        }

        protected void appendAnnotations(Iterable<JavaAnnotation> annotations) {
            for (JavaAnnotation annotation : annotations) {
                this.appendLine(annotation.getSourcePosition(), JavaUtil.validateAnnotation(this.alertSink, annotation));
            }
        }

        protected static void appendJavaThrowsDeclaration(StringBuilder sb, Iterable<ThrowsDeclaration> throwsDeclarations) {
            sb.append("\n    throws ");
            LinkedHashSet<String> excTypes = Sets.newLinkedHashSet();
            excTypes.add("java.io.IOException");
            for (ThrowsDeclaration throwsDeclaration : throwsDeclarations) {
                excTypes.add(throwsDeclaration.getExceptionType());
            }
            Join.join(sb, ", ", excTypes);
        }

        protected String getClassName(TemplateName name) {
            return name == null ? null : name.getBaseName();
        }

        protected String toJavaType(Type type) {
            return type.acceptTypeVisitor(new TypeVisitor<String>(){

                @Override
                public String visitBooleanType(BooleanType type) {
                    return "boolean";
                }

                @Override
                public String visitBundleType(BundleType type) {
                    StringBuilder sb = new StringBuilder("com.google.gxp.base.GxpAttrBundle<");
                    sb.append(type.getSchema().getJavaType());
                    sb.append(">");
                    return sb.toString();
                }

                @Override
                public String visitContentType(ContentType type) {
                    return type.getSchema().getJavaType();
                }

                @Override
                public String visitInstanceType(InstanceType type) {
                    return type.getTemplateName().toString() + ".Interface";
                }

                @Override
                public String visitNativeType(NativeType type) {
                    return JavaUtil.validateType(Worker.this.alertSink, type);
                }

                @Override
                public String visitTemplateType(TemplateType type) {
                    return type.getTemplateName().toString();
                }
            });
        }

        protected List<String> toBoundedTypeDecls(boolean includeExtends, Iterable<FormalTypeParameter> formalTypeParameters) {
            ArrayList<String> result = Lists.newArrayList();
            for (FormalTypeParameter formalTypeParameter : formalTypeParameters) {
                if (!includeExtends || formalTypeParameter.getExtendsType() == null) {
                    result.add(formalTypeParameter.getName());
                    continue;
                }
                String type = JavaUtil.validateConjunctiveType(this.alertSink, formalTypeParameter.getExtendsType());
                result.add(formalTypeParameter.getName() + " extends " + type);
            }
            return result;
        }

        protected void appendJavaFormalTypeParameters(StringBuilder sb, boolean includeExtends, List<FormalTypeParameter> formalTypeParameters) {
            if (!formalTypeParameters.isEmpty()) {
                sb.append("<");
                Join.join(sb, ", ", this.toBoundedTypeDecls(includeExtends, formalTypeParameters));
                sb.append(">");
            }
        }

        protected static String loadFormat(String name) {
            return BaseJavaCodeGenerator.loadFormat("java/" + name);
        }
    }
}

