/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.reparent;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.InvalidAttributeValueError;
import com.google.gxp.compiler.alerts.common.MissingAttributeError;
import com.google.gxp.compiler.alerts.common.MultiValueAttributeError;
import com.google.gxp.compiler.alerts.common.RequiredAttributeHasCondError;
import com.google.gxp.compiler.alerts.common.UnknownAttributeError;
import com.google.gxp.compiler.base.AttributeName;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.MultiLanguageAttrValue;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.parser.CppNamespace;
import com.google.gxp.compiler.parser.JavaNamespace;
import com.google.gxp.compiler.parser.JavaScriptNamespace;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NullNamespace;
import com.google.gxp.compiler.parser.OutputLanguageNamespace;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.reparent.ConflictingAttributesError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AttributeMap {
    private final AlertSink alertSink;
    private final Node forNode;
    private final Map<AttributeName, Attribute> namesToAttrs = Maps.newLinkedHashMap();
    private final Set<AttributeName> used = Sets.newHashSet();
    private static final ImmutableList<OutputLanguageNamespace> outputLanguageNamespaces = ImmutableList.of(CppNamespace.INSTANCE, JavaNamespace.INSTANCE, JavaScriptNamespace.INSTANCE);

    public AttributeMap(AlertSink alertSink, Node forNode) {
        this.alertSink = Preconditions.checkNotNull(alertSink);
        this.forNode = Preconditions.checkNotNull(forNode);
    }

    public void add(Attribute attr) {
        AttributeName key = new AttributeName(attr.getNamespace(), attr.getName());
        if (this.namesToAttrs.containsKey(key)) {
            this.alertSink.add(new MultiValueAttributeError(this.forNode, attr));
        } else {
            this.namesToAttrs.put(key, attr);
        }
    }

    public List<Attribute> getUnusedAttributes() {
        ArrayList<Attribute> result = Lists.newArrayList();
        HashSet<String> usedLocalNames = Sets.newHashSet();
        for (AttributeName attributeName : this.namesToAttrs.keySet()) {
            if (this.used.contains(attributeName)) continue;
            Namespace ns = attributeName.getNamespace();
            String localName = attributeName.getLocalName();
            if (!(ns instanceof OutputLanguageNamespace) && !(ns instanceof NullNamespace)) {
                this.used.add(attributeName);
                result.add(this.namesToAttrs.get(attributeName));
                continue;
            }
            if (usedLocalNames.contains(localName)) continue;
            usedLocalNames.add(localName);
            Attribute nullAttr = this.getAttribute(localName);
            if (nullAttr != null && !(nullAttr.getValue() instanceof NativeExpression)) {
                result.add(nullAttr);
                continue;
            }
            result.add(new Attribute(this.forNode, localName, this.getExprImpl(localName, null, false), null));
        }
        for (Map.Entry entry : this.namesToAttrs.entrySet()) {
            if (this.used.contains(entry.getKey())) continue;
            this.used.add((AttributeName)entry.getKey());
            this.alertSink.add(new MultiValueAttributeError(this.forNode, (Attribute)entry.getValue()));
        }
        return ImmutableList.copyOf(result);
    }

    public Attribute getAttribute(Namespace ns, String name) {
        AttributeName key = new AttributeName(ns, name);
        this.used.add(key);
        return this.namesToAttrs.get(key);
    }

    private Expression getValueImpl(Namespace ns, String name, Expression fallback, boolean optional) {
        Attribute attr = this.getAttribute(ns, name);
        if (attr == null) {
            if (!optional) {
                this.alertSink.add(new MissingAttributeError(this.forNode, name));
            }
            return fallback;
        }
        return attr.getValue();
    }

    private Expression getExprImpl(String name, Expression fallback, boolean optional) {
        Expression value = this.getValueImpl(NullNamespace.INSTANCE, name, null, true);
        if (value != null && !(value instanceof StringConstant) && !(value instanceof NativeExpression)) {
            return value;
        }
        MultiLanguageAttrValue mlar = this.getMultiLanguageAttrValue(name, true);
        if (mlar.isEmpty()) {
            if (!optional) {
                this.alertSink.add(new MissingAttributeError(this.forNode, name));
            }
            return fallback;
        }
        return new NativeExpression(this.forNode.getSourcePosition(), "'" + name + "' attribute", mlar);
    }

    public Expression getValue(Namespace ns, String name, Expression fallback) {
        return this.getValueImpl(ns, name, fallback, false);
    }

    private String getImpl(Namespace ns, String name, String fallback, boolean optional) {
        Expression value = this.getValueImpl(ns, name, null, optional);
        if (value == null) {
            return fallback;
        }
        return value.getStaticString(this.alertSink, fallback);
    }

    public String get(Namespace ns, String name, String fallback) {
        return this.getImpl(ns, name, fallback, false);
    }

    public String getOptional(Namespace ns, String name, String fallback) {
        return this.getImpl(ns, name, fallback, true);
    }

    public Expression getValue(String name, Expression fallback) {
        return this.getValue(NullNamespace.INSTANCE, name, fallback);
    }

    public String get(String name, String fallback) {
        return this.get(NullNamespace.INSTANCE, name, fallback);
    }

    public String getOptional(String name, String fallback) {
        return this.getOptional(NullNamespace.INSTANCE, name, fallback);
    }

    public Expression getExprValue(String name, Expression fallback) {
        return this.getExprImpl(name, fallback, false);
    }

    public Expression getOptionalExprValue(String name, Expression fallback) {
        return this.getExprImpl(name, fallback, true);
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(NullNamespace.INSTANCE, name);
    }

    public static Iterable<OutputLanguageNamespace> getOutputLanguageNamespaces() {
        return outputLanguageNamespaces;
    }

    public MultiLanguageAttrValue getMultiLanguageAttrValue(String name) {
        return this.getMultiLanguageAttrValue(name, false);
    }

    public MultiLanguageAttrValue getMultiLanguageAttrValue(String name, boolean forExpr) {
        HashMap<OutputLanguage, String> map = Maps.newHashMap();
        for (OutputLanguageNamespace ns : outputLanguageNamespaces) {
            String value = this.getOptional(ns, name, null);
            if (value == null) continue;
            map.put(ns.getOutputLanguage(), value);
        }
        String defaultStr = null;
        if (forExpr) {
            Expression expr = this.getValueImpl(NullNamespace.INSTANCE, name, null, true);
            if (expr != null) {
                defaultStr = expr instanceof NativeExpression ? ((NativeExpression)expr).getDefaultNativeCode() : expr.getStaticString(this.alertSink, null);
            }
        } else {
            defaultStr = this.getOptional(name, null);
        }
        return new MultiLanguageAttrValue(map, defaultStr);
    }

    public boolean getBooleanValue(String name) {
        String str = this.getOptional(name, null);
        if (str == null || str.equals("false")) {
            return false;
        }
        if (str.equals("true")) {
            return true;
        }
        this.alertSink.add(new InvalidAttributeValueError(this.getAttribute(name)));
        return false;
    }

    public Expression getOptionalAttributeValue(String name, Expression fallback) {
        Expression result = null;
        Attribute nullAttr = this.getAttribute(name);
        if (nullAttr != null) {
            if (nullAttr.getCondition() != null) {
                this.alertSink.add(new RequiredAttributeHasCondError(this.forNode, nullAttr));
            }
            result = nullAttr.getValue();
        }
        if (result == null || result instanceof NativeExpression) {
            result = this.getOptionalExprValue(name, null);
        } else {
            for (OutputLanguageNamespace ns : outputLanguageNamespaces) {
                Attribute attr = this.getAttribute(ns, name);
                if (attr == null) continue;
                this.alertSink.add(new ConflictingAttributesError(this.forNode, nullAttr, attr));
            }
        }
        return result == null ? fallback : result;
    }

    public void reportUnusedAttributes() {
        for (Map.Entry<AttributeName, Attribute> entry : this.namesToAttrs.entrySet()) {
            if (this.used.contains(entry.getKey())) continue;
            this.alertSink.add(new UnknownAttributeError(this.forNode, entry.getValue()));
        }
    }
}

