/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.List;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TupleReceiver;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;

public class AppendCollector
implements TridentCollector {
    TridentTupleView.OperationOutputFactory factory;
    TridentContext triContext;
    TridentTuple tuple;
    ProcessorContext context;

    public AppendCollector(TridentContext context) {
        this.triContext = context;
        this.factory = new TridentTupleView.OperationOutputFactory(context.getParentTupleFactories().get(0), context.getSelfOutputFields());
    }

    public void setContext(ProcessorContext pc, TridentTuple t) {
        this.context = pc;
        this.tuple = t;
    }

    @Override
    public void emit(List<Object> values) {
        TridentTuple toEmit = this.factory.create((TridentTupleView)this.tuple, values);
        for (TupleReceiver r : this.triContext.getReceivers()) {
            r.execute(this.context, this.triContext.getOutStreamId(), toEmit);
        }
    }

    @Override
    public void flush() {
        for (TupleReceiver r : this.triContext.getReceivers()) {
            r.flush();
        }
    }

    @Override
    public void reportError(Throwable t) {
        this.triContext.getDelegateCollector().reportError(t);
    }

    public TridentTuple.Factory getOutputFactory() {
        return this.factory;
    }
}

