/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.equivalence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceSet;

public class EquivalenceSetCreator<E, C> {
    private static final EqGroupSizeComparator groupSizeComparator = new EqGroupSizeComparator();

    @Deprecated
    public static <EE, CC> EquivalenceSet[] createEqualityGroupOrderedArray(EE[] aElementsArray, EquivalenceComparator<? super EE, ? super CC> aEqComparator, CC aContext) {
        return EquivalenceSetCreator.createEqualityGroupOrderedArray(Arrays.asList(aElementsArray), aEqComparator, aContext);
    }

    public static <EE, CC> EquivalenceSet[] createEqualityGroupOrderedArray(Collection<EE> elements, EquivalenceComparator<? super EE, ? super CC> aEqComparator, CC aContext) {
        ArrayList<EquivalenceSet<? super EE, ? super CC>> arrayList = new ArrayList<EquivalenceSet<? super EE, ? super CC>>();
        HashMap<Integer, List<EquivalenceSet<EE, CC>>> map = EquivalenceSetCreator.createEqualityGroupMap(elements, aEqComparator, aContext);
        for (List<EquivalenceSet<EE, CC>> list : map.values()) {
            for (EquivalenceSet<? super EE, ? super CC> equivalenceSet : list) {
                arrayList.add(equivalenceSet);
            }
        }
        EquivalenceSet[] resultArray = new EquivalenceSet[arrayList.size()];
        arrayList.toArray(resultArray);
        Arrays.sort(resultArray, groupSizeComparator);
        return resultArray;
    }

    private static <EE, CC> HashMap<Integer, List<EquivalenceSet<? super EE, ? super CC>>> createEqualityGroupMap(Collection<EE> elements, EquivalenceComparator<? super EE, ? super CC> aEqComparator, CC aComparatorContext) {
        HashMap<Integer, List<EquivalenceSet<EE, CC>>> equalityGroupMap = new HashMap<Integer, List<EquivalenceSet<EE, CC>>>(elements.size());
        for (EE curentElement : elements) {
            int hashcode = aEqComparator.equivalenceHashcode(curentElement, aComparatorContext);
            List<EquivalenceSet<EE, CC>> list = equalityGroupMap.get(hashcode);
            if (list == null) {
                list = new LinkedList<EquivalenceSet<? super EE, ? super CC>>();
                list.add(new EquivalenceSet<EE, CC>(curentElement, aEqComparator, aComparatorContext));
                equalityGroupMap.put(hashcode, list);
                continue;
            }
            boolean eqWasFound = false;
            for (EquivalenceSet<EE, CC> eqGroup : list) {
                if (!eqGroup.equivalentTo(curentElement, aComparatorContext)) continue;
                eqGroup.add(curentElement);
                eqWasFound = true;
                break;
            }
            if (eqWasFound) continue;
            list.add(new EquivalenceSet<EE, CC>(curentElement, aEqComparator, aComparatorContext));
        }
        return equalityGroupMap;
    }

    private static class EqGroupSizeComparator
    implements Comparator<EquivalenceSet> {
        private EqGroupSizeComparator() {
        }

        @Override
        public int compare(EquivalenceSet arg1, EquivalenceSet arg2) {
            int eqGroupHash2;
            int eqGroupSize2;
            int eqGroupSize1 = arg1.size();
            if (eqGroupSize1 > (eqGroupSize2 = arg2.size())) {
                return 1;
            }
            if (eqGroupSize1 < eqGroupSize2) {
                return -1;
            }
            int eqGroupHash1 = arg1.hashCode();
            if (eqGroupHash1 > (eqGroupHash2 = arg2.hashCode())) {
                return 1;
            }
            if (eqGroupHash1 < eqGroupHash2) {
                return -1;
            }
            return 0;
        }
    }
}

