/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.tuple;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;

public class ComboList
extends AbstractList<Object> {
    Pointer[] index;
    List[] delegates;

    public ComboList(List[] delegates, Pointer[] index) {
        this.index = index;
        this.delegates = delegates;
    }

    @Override
    public Object get(int i) {
        Pointer ptr = this.index[i];
        return this.delegates[ptr.listIndex].get(ptr.subIndex);
    }

    @Override
    public int size() {
        return this.index.length;
    }

    private static class Pointer
    implements Serializable {
        int listIndex;
        int subIndex;

        Pointer(int listIndex, int subIndex) {
            this.listIndex = listIndex;
            this.subIndex = subIndex;
        }
    }

    public static class Factory
    implements Serializable {
        Pointer[] index;
        int[] sizes;

        public Factory(int ... sizes) {
            this.sizes = sizes;
            int total = 0;
            for (int size : sizes) {
                total += size;
            }
            this.index = new Pointer[total];
            int i = 0;
            int j = 0;
            for (int size : sizes) {
                for (int z = 0; z < size; ++z) {
                    this.index[j] = new Pointer(i, z);
                    ++j;
                }
                ++i;
            }
        }

        public ComboList create(List[] delegates) {
            if (delegates.length != this.sizes.length) {
                throw new RuntimeException("Expected " + this.sizes.length + " lists, but instead got " + delegates.length + " lists");
            }
            for (int i = 0; i < delegates.length; ++i) {
                List l = delegates[i];
                if (l != null && l.size() == this.sizes[i]) continue;
                throw new RuntimeException("Got unexpected delegates to ComboList: " + ToStringBuilder.reflectionToString((Object)delegates));
            }
            return new ComboList(delegates, this.index);
        }
    }
}

