/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusInfo
implements Serializable {
    private static final long serialVersionUID = 2161446155116099333L;
    private static final Logger LOG = LoggerFactory.getLogger(NimbusInfo.class);
    private static final Pattern NON_TLS_HOST_PORT_PATTERN_FALLBACK = Pattern.compile("^(.*):([0-9]+)$");
    private static final Pattern TLS_HOST_PORT_PATTERN = Pattern.compile("^(.*):([0-9]+):([0-9]+)$");
    private String host;
    private int port;
    private int tlsPort;
    private boolean isLeader;

    public NimbusInfo(String host, int port, boolean isLeader) {
        if (host == null) {
            throw new NullPointerException("Host cannot be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port cannot be negative");
        }
        this.host = host;
        this.port = port;
        this.isLeader = isLeader;
    }

    public NimbusInfo(String host, int port, int tlsPort, boolean isLeader) {
        this(host, port, isLeader);
        this.tlsPort = tlsPort;
    }

    public static NimbusInfo parse(String nimbusInfo) {
        Matcher m = TLS_HOST_PORT_PATTERN.matcher(nimbusInfo);
        if (m.matches()) {
            return new NimbusInfo(m.group(1), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), false);
        }
        LOG.info("nimbusInfo {} doesn't match the format of host:port:tlsPort; fall back to the non-tls format host:port", (Object)nimbusInfo);
        m = NON_TLS_HOST_PORT_PATTERN_FALLBACK.matcher(nimbusInfo);
        if (m.matches()) {
            return new NimbusInfo(m.group(1), Integer.parseInt(m.group(2)), false);
        }
        throw new RuntimeException("nimbusInfo should have format of host:port:tlsPort or host:port, invalid string " + nimbusInfo);
    }

    public static NimbusInfo fromConf(Map<String, Object> conf) {
        try {
            String host = InetAddress.getLocalHost().getCanonicalHostName();
            if (conf.containsKey("storm.local.hostname")) {
                host = (String)conf.get("storm.local.hostname");
                LOG.info("Overriding nimbus host to storm.local.hostname -> {}", (Object)host);
            } else {
                LOG.info("Nimbus figures out its name to {}", (Object)host);
            }
            int port = ObjectReader.getInt(conf.get("nimbus.thrift.port"), 6627);
            int tlsPort = ObjectReader.getInt(conf.get("nimbus.thrift.tls.port"));
            return new NimbusInfo(host, port, tlsPort, false);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Something wrong with network/dns config, host cant figure out its name", e);
        }
    }

    public String toHostPortString() {
        return String.format("%s:%s:%s", this.host, this.port, this.tlsPort);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public int getPort() {
        return this.port;
    }

    public int getTlsPort() {
        return this.tlsPort;
    }

    public String getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NimbusInfo)) {
            return false;
        }
        NimbusInfo that = (NimbusInfo)o;
        if (this.isLeader != that.isLeader) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (this.tlsPort != that.tlsPort) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + this.tlsPort;
        result2 = 31 * result2 + (this.isLeader ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "NimbusInfo{host='" + this.host + "', port=" + this.port + ", tlsPort=" + this.tlsPort + ", isLeader=" + this.isLeader + "}";
    }
}

