/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.command;

import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.storm.command.CLI;
import org.apache.storm.generated.RebalanceOptions;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rebalance {
    private static final Logger LOG = LoggerFactory.getLogger(Rebalance.class);

    public static void main(String[] args) throws Exception {
        Map resourceOverrides;
        Map numExecutors;
        Integer numWorkers;
        Map<String, Object> cl = CLI.opt("w", "wait", null, CLI.AS_INT).opt("n", "num-workers", null, CLI.AS_INT).opt("e", "executor", null, new ExecutorParser(), CLI.INTO_MAP).opt("r", "resources", null, new ResourcesParser(), CLI.INTO_MAP).opt("t", "topology-conf", null, new ConfParser(), CLI.INTO_MAP).arg("topologyName", CLI.FIRST_WINS).parse(args);
        String name = (String)cl.get("topologyName");
        Utils.validateTopologyName((String)name);
        RebalanceOptions rebalanceOptions = new RebalanceOptions();
        Integer wait = (Integer)cl.get("w");
        if (null != wait) {
            rebalanceOptions.set_wait_secs(wait.intValue());
        }
        if (null != (numWorkers = (Integer)cl.get("n"))) {
            rebalanceOptions.set_num_workers(numWorkers.intValue());
        }
        if (null != (numExecutors = (Map)cl.get("e"))) {
            rebalanceOptions.set_num_executors(numExecutors);
        }
        if (null != (resourceOverrides = (Map)cl.get("r"))) {
            rebalanceOptions.set_topology_resources_overrides(resourceOverrides);
        }
        Map confOverrides = (Map)cl.get("t");
        Map jvmOpts = Utils.readCommandLineOpts();
        if (jvmOpts != null && !jvmOpts.isEmpty()) {
            if (confOverrides == null) {
                confOverrides = jvmOpts;
            } else {
                confOverrides.putAll(jvmOpts);
            }
            LOG.info("Rebalancing topology with overrides {}", (Object)JSONObject.toJSONString((Map)confOverrides));
        }
        if (null != confOverrides) {
            rebalanceOptions.set_topology_conf_overrides(JSONValue.toJSONString((Object)confOverrides));
        }
        NimbusClient.withConfiguredClient(nimbus -> {
            nimbus.rebalance(name, rebalanceOptions);
            LOG.info("Topology {} is rebalancing", (Object)name);
        });
    }

    static final class ExecutorParser
    implements CLI.Parse {
        ExecutorParser() {
        }

        @Override
        public Object parse(String value) {
            try {
                int splitIndex = value.lastIndexOf(61);
                String componentName = value.substring(0, splitIndex);
                Integer parallelism = Integer.parseInt(value.substring(splitIndex + 1));
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put(componentName, parallelism);
                return result;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException(String.format("Failed to parse '%s' correctly. Expected in <component>=<parallelism> format", value), ex);
            }
        }
    }

    static final class ResourcesParser
    implements CLI.Parse {
        ResourcesParser() {
        }

        @Override
        public Object parse(String value) {
            if (value == null) {
                throw new RuntimeException("No arguments found for topology resources override!");
            }
            try {
                HashMap ret = new HashMap();
                for (Map.Entry compEntry : Utils.parseJson((String)value).entrySet()) {
                    String comp = (String)compEntry.getKey();
                    Map numResources = (Map)compEntry.getValue();
                    HashMap<String, Double> doubleResource = new HashMap<String, Double>();
                    for (Map.Entry entry : numResources.entrySet()) {
                        doubleResource.put((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
                    }
                    ret.put(comp, doubleResource);
                }
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException("Error trying to parse resource override", e);
            }
        }
    }

    static final class ConfParser
    implements CLI.Parse {
        ConfParser() {
        }

        @Override
        public Object parse(String value) {
            if (value == null) {
                throw new RuntimeException("No arguments found for topology config override!");
            }
            try {
                return Utils.parseJson((String)value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error trying to parse topology config override", e);
            }
        }
    }
}

