/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.errorprone.annotations.RestrictedApi;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ScheduledChore
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledChore.class);
    private final String name;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final long DEFAULT_INITIAL_DELAY = 0L;
    private final int period;
    private final TimeUnit timeUnit;
    private final long initialDelay;
    private ChoreService choreService;
    private long timeOfLastRun = -1L;
    private long timeOfThisRun = -1L;
    private boolean initialChoreComplete = false;
    private final Stoppable stopper;

    @InterfaceAudience.Private
    protected ScheduledChore() {
        this("TestChore", null, 0, 0L, DEFAULT_TIME_UNIT);
    }

    public ScheduledChore(String name, Stoppable stopper, int period) {
        this(name, stopper, period, 0L);
    }

    public ScheduledChore(String name, Stoppable stopper, int period, long initialDelay) {
        this(name, stopper, period, initialDelay, DEFAULT_TIME_UNIT);
    }

    public ScheduledChore(String name, Stoppable stopper, int period, long initialDelay, TimeUnit unit) {
        this.name = name;
        this.stopper = stopper;
        this.period = period;
        this.initialDelay = initialDelay < 0L ? 0L : initialDelay;
        this.timeUnit = unit;
    }

    @Override
    public void run() {
        block10: {
            this.updateTimeTrackingBeforeRun();
            if (this.missedStartTime() && this.isScheduled()) {
                this.onChoreMissedStartTime();
                LOG.info("Chore: {} missed its start time", (Object)this.getName());
            } else if (this.stopper.isStopped() || !this.isScheduled()) {
                this.shutdown(false);
                LOG.info("Chore: {} was stopped", (Object)this.getName());
            } else {
                try {
                    long start = 0L;
                    if (LOG.isDebugEnabled()) {
                        start = System.nanoTime();
                    }
                    if (!this.initialChoreComplete) {
                        this.initialChoreComplete = this.initialChore();
                    } else {
                        this.chore();
                    }
                    if (LOG.isDebugEnabled() && start > 0L) {
                        long end = System.nanoTime();
                        LOG.debug("{} execution time: {} ms.", (Object)this.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
                    }
                }
                catch (Throwable t) {
                    LOG.error("Caught error", t);
                    if (!this.stopper.isStopped()) break block10;
                    this.cancel(false);
                }
            }
        }
    }

    private synchronized void updateTimeTrackingBeforeRun() {
        this.timeOfLastRun = this.timeOfThisRun;
        this.timeOfThisRun = EnvironmentEdgeManager.currentTime();
    }

    private synchronized void onChoreMissedStartTime() {
        if (this.choreService != null) {
            this.choreService.onChoreMissedStartTime(this);
        }
    }

    synchronized long getTimeBetweenRuns() {
        return this.timeOfThisRun - this.timeOfLastRun;
    }

    private synchronized boolean missedStartTime() {
        return this.isValidTime(this.timeOfLastRun) && this.isValidTime(this.timeOfThisRun) && (double)this.getTimeBetweenRuns() > this.getMaximumAllowedTimeBetweenRuns();
    }

    private double getMaximumAllowedTimeBetweenRuns() {
        return 1.5 * (double)this.timeUnit.toMillis(this.period);
    }

    private synchronized boolean isValidTime(long time) {
        return time > 0L && time <= EnvironmentEdgeManager.currentTime();
    }

    public synchronized boolean triggerNow() {
        if (this.choreService == null) {
            return false;
        }
        this.choreService.triggerNow(this);
        return true;
    }

    @RestrictedApi(explanation="Should only be called in ChoreService", link="", allowedOnPath=".*/org/apache/hadoop/hbase/ChoreService.java")
    synchronized void setChoreService(ChoreService service) {
        this.choreService = service;
        this.timeOfThisRun = -1L;
    }

    public synchronized void cancel() {
        this.cancel(true);
    }

    public synchronized void cancel(boolean mayInterruptIfRunning) {
        if (this.isScheduled()) {
            this.choreService.cancelChore(this, mayInterruptIfRunning);
        }
        this.choreService = null;
    }

    public String getName() {
        return this.name;
    }

    public Stoppable getStopper() {
        return this.stopper;
    }

    public int getPeriod() {
        return this.period;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public synchronized boolean isInitialChoreComplete() {
        return this.initialChoreComplete;
    }

    synchronized ChoreService getChoreService() {
        return this.choreService;
    }

    synchronized long getTimeOfLastRun() {
        return this.timeOfLastRun;
    }

    synchronized long getTimeOfThisRun() {
        return this.timeOfThisRun;
    }

    public synchronized boolean isScheduled() {
        return this.choreService != null && this.choreService.isChoreScheduled(this);
    }

    @InterfaceAudience.Private
    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public synchronized void choreForTesting() {
        this.chore();
    }

    protected abstract void chore();

    protected boolean initialChore() {
        return true;
    }

    protected void cleanup() {
    }

    public synchronized void shutdown() {
        this.shutdown(true);
    }

    public synchronized void shutdown(boolean mayInterruptIfRunning) {
        this.cancel(mayInterruptIfRunning);
        this.cleanup();
    }

    @InterfaceAudience.Private
    public String toString() {
        return "ScheduledChore name=" + this.getName() + ", period=" + this.getPeriod() + ", unit=" + (Object)((Object)this.getTimeUnit());
    }
}

