/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Blob;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.util.StringUtil;

abstract class SQLBinary
extends DataType
implements BitDataValue {
    static final byte PAD = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBinary.class);
    private static final int LEN_OF_BUFFER_TO_WRITE_BLOB = 1024;
    Blob _blobValue;
    byte[] dataValue;
    InputStream stream;
    int streamValueLength;

    public int estimateMemoryUsage() {
        if (this.dataValue == null) {
            if (this.streamValueLength >= 0) {
                return BASE_MEMORY_USAGE + this.streamValueLength;
            }
            return this.getMaxMemoryUsage();
        }
        return BASE_MEMORY_USAGE + this.dataValue.length;
    }

    abstract int getMaxMemoryUsage();

    SQLBinary() {
    }

    SQLBinary(byte[] byArray) {
        this.dataValue = byArray;
    }

    SQLBinary(Blob blob) {
        this.setValue(blob);
    }

    public final void setValue(byte[] byArray) {
        this.dataValue = byArray;
        this._blobValue = null;
        this.stream = null;
        this.streamValueLength = -1;
    }

    public final void setValue(Blob blob) {
        this.dataValue = null;
        this._blobValue = blob;
        this.stream = null;
        this.streamValueLength = -1;
    }

    public final String getString() throws StandardException {
        if (this.getValue() == null) {
            return null;
        }
        if (this.dataValue.length * 2 < 0) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)"", (Object)String.valueOf(Integer.MAX_VALUE));
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final InputStream getStream() throws StandardException {
        if (!this.hasStream()) {
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        return this.stream;
    }

    public final byte[] getBytes() throws StandardException {
        return this.getValue();
    }

    byte[] getValue() throws StandardException {
        try {
            if (this.dataValue == null && this._blobValue != null) {
                this.dataValue = this._blobValue.getBytes(1L, this.getBlobLength());
                this._blobValue = null;
                this.stream = null;
                this.streamValueLength = -1;
            } else if (this.dataValue == null && this.stream != null) {
                if (this.stream instanceof FormatIdInputStream) {
                    this.readExternal((FormatIdInputStream)this.stream);
                } else {
                    this.readExternal(new FormatIdInputStream(this.stream));
                }
                this._blobValue = null;
                this.stream = null;
                this.streamValueLength = -1;
            }
        }
        catch (IOException iOException) {
            this.throwStreamingIOException(iOException);
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
        return this.dataValue;
    }

    public final int getLength() throws StandardException {
        byte[] byArray;
        if (this._blobValue != null) {
            return this.getBlobLength();
        }
        if (this.stream != null) {
            if (this.streamValueLength != -1) {
                return this.streamValueLength;
            }
            if (this.stream instanceof Resetable) {
                try {
                    this.streamValueLength = SQLBinary.readBinaryLength((ObjectInput)((Object)this.stream));
                    if (this.streamValueLength == 0) {
                        this.streamValueLength = (int)InputStreamUtil.skipUntilEOF(this.stream);
                    }
                    int n = this.streamValueLength;
                    return n;
                }
                catch (IOException iOException) {
                    this.throwStreamingIOException(iOException);
                }
                finally {
                    try {
                        ((Resetable)((Object)this.stream)).resetStream();
                    }
                    catch (IOException iOException) {
                        this.throwStreamingIOException(iOException);
                    }
                }
            }
        }
        return (byArray = this.getBytes()) == null ? 0 : byArray.length;
    }

    private void throwStreamingIOException(IOException iOException) throws StandardException {
        throw StandardException.newException("XCL30.S", iOException, (Object)this.getTypeName());
    }

    public final boolean isNull() {
        return this.dataValue == null && this.stream == null && this._blobValue == null;
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._blobValue != null) {
            this.writeBlob(objectOutput);
            return;
        }
        int n = this.dataValue.length;
        this.writeLength(objectOutput, n);
        objectOutput.write(this.dataValue, 0, this.dataValue.length);
    }

    private void writeBlob(ObjectOutput objectOutput) throws IOException {
        try {
            int n = this.getBlobLength();
            InputStream inputStream = this._blobValue.getBinaryStream();
            this.writeLength(objectOutput, n);
            int n2 = 0;
            byte[] byArray = new byte[Math.min(n, 1024)];
            for (int i = 0; i < n; i += n2) {
                n2 = inputStream.read(byArray);
                if (n2 == -1) {
                    throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
                }
                objectOutput.write(byArray, 0, n2);
            }
        }
        catch (StandardException standardException) {
            throw new IOException(standardException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void writeLength(ObjectOutput objectOutput, int n) throws IOException {
        if (n <= 31) {
            objectOutput.write((byte)(0x80 | n & 0xFF));
        } else if (n <= 65535) {
            objectOutput.write(-96);
            objectOutput.writeShort((short)n);
        } else {
            objectOutput.write(-64);
            objectOutput.writeInt(n);
        }
    }

    public final void readExternal(ObjectInput objectInput) throws IOException {
        this.stream = null;
        this.streamValueLength = -1;
        this._blobValue = null;
        int n = SQLBinary.readBinaryLength(objectInput);
        if (n != 0) {
            this.dataValue = new byte[n];
            objectInput.readFully(this.dataValue);
        } else {
            this.readFromStream((InputStream)((Object)objectInput));
        }
    }

    private static int readBinaryLength(ObjectInput objectInput) throws IOException {
        int n;
        int n2 = objectInput.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        byte by = (byte)n2;
        if ((by & 0xFFFFFF80) != 0) {
            n = by == -64 ? objectInput.readInt() : (by == -96 ? objectInput.readUnsignedShort() : by & 0x1F);
        } else {
            int n3 = objectInput.read();
            int n4 = objectInput.read();
            int n5 = objectInput.read();
            if (n3 == -1 || n4 == -1 || n5 == -1) {
                throw new EOFException();
            }
            int n6 = (n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n5 & 0xFF;
            n = n6 / 8;
            if (n6 % 8 != 0) {
                ++n;
            }
        }
        return n;
    }

    private void readFromStream(InputStream inputStream) throws IOException {
        int n;
        this.dataValue = null;
        byte[] byArray = new byte[32768];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            int n3 = Math.max(1, inputStream.available());
            int n4 = n3 - (byArray.length - (n2 += n));
            if (n4 <= 0) continue;
            int n5 = byArray.length * 2;
            if (n4 > byArray.length) {
                n5 += n4;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        this.dataValue = new byte[n2];
        System.arraycopy(byArray, 0, this.dataValue, 0, n2);
    }

    public final void restoreToNull() {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = null;
        this.streamValueLength = -1;
    }

    public final boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        if (this.isNull() || dataValueDescriptor.isNull()) {
            if (!this.isNull()) {
                return -1;
            }
            if (!dataValueDescriptor.isNull()) {
                return 1;
            }
            return 0;
        }
        return SQLBinary.compare(this.getBytes(), dataValueDescriptor.getBytes());
    }

    public final DataValueDescriptor cloneHolder() {
        if (this.stream == null && this._blobValue == null) {
            return this.cloneValue(false);
        }
        SQLBinary sQLBinary = (SQLBinary)this.getNewNull();
        if (this.stream != null) {
            sQLBinary.setValue(this.stream, this.streamValueLength);
        } else if (this._blobValue != null) {
            sQLBinary.setValue(this._blobValue);
        } else {
            throw new IllegalStateException("unknown BLOB value repr");
        }
        return sQLBinary;
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        try {
            DataValueDescriptor dataValueDescriptor = this.getNewNull();
            dataValueDescriptor.setValue(this.getValue());
            return dataValueDescriptor;
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public final InputStream returnStream() {
        return this.stream;
    }

    public final void setStream(InputStream inputStream) {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = inputStream;
        this.streamValueLength = -1;
    }

    public final void loadStream() throws StandardException {
        this.getValue();
    }

    boolean objectNull(Object object) {
        if (object == null) {
            this.setToNull();
            return true;
        }
        return false;
    }

    public final void setValue(InputStream inputStream, int n) {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = inputStream;
        this.streamValueLength = n;
    }

    protected final void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLBinary) {
            SQLBinary sQLBinary = (SQLBinary)dataValueDescriptor;
            this.dataValue = sQLBinary.dataValue;
            this._blobValue = sQLBinary._blobValue;
            this.stream = sQLBinary.stream;
            this.streamValueLength = sQLBinary.streamValueLength;
        } else {
            this.setValue(dataValueDescriptor.getBytes());
        }
    }

    public final BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) == 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) != 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) < 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) > 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) <= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = false;
        bl = dataValueDescriptor.isNull() || dataValueDescriptor2.isNull() ? false : SQLBinary.compare(dataValueDescriptor.getBytes(), dataValueDescriptor2.getBytes()) >= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public final NumberDataValue charLength(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getValue().length);
        return numberDataValue;
    }

    public final BitDataValue concatenate(BitDataValue bitDataValue, BitDataValue bitDataValue2, BitDataValue bitDataValue3) throws StandardException {
        if (bitDataValue3 == null) {
            bitDataValue3 = (BitDataValue)this.getNewNull();
        }
        if (bitDataValue.isNull() || bitDataValue2.isNull()) {
            bitDataValue3.setToNull();
            return bitDataValue3;
        }
        byte[] byArray = bitDataValue.getBytes();
        byte[] byArray2 = bitDataValue2.getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        bitDataValue3.setValue(byArray3);
        return bitDataValue3;
    }

    public final ConcatableDataValue substring(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, ConcatableDataValue concatableDataValue, int n) throws StandardException {
        if (concatableDataValue == null) {
            concatableDataValue = new SQLVarbit();
        }
        BitDataValue bitDataValue = (BitDataValue)concatableDataValue;
        if (this.isNull() || numberDataValue.isNull() || numberDataValue2 != null && numberDataValue2.isNull()) {
            bitDataValue.setToNull();
            return bitDataValue;
        }
        int n2 = numberDataValue.getInt();
        int n3 = numberDataValue2 != null ? numberDataValue2.getInt() : this.getLength() - n2 + 1;
        if (n2 <= 0 || n3 < 0 || n2 > this.getLength() || n3 > this.getLength() - n2 + 1) {
            throw StandardException.newException("22011");
        }
        if (n3 < 0) {
            bitDataValue.setToNull();
            return bitDataValue;
        }
        if (n2 < 0) {
            if ((n2 += this.getLength()) < 0) {
                n3 += n2;
                n2 = 0;
            }
            n3 = n3 + n2 > 0 ? (n3 += n2) : 0;
        } else if (n2 > 0) {
            --n2;
        }
        if (n3 == 0 || n3 <= 0 - n2 || n2 > this.getLength()) {
            bitDataValue.setValue(new byte[0]);
            return bitDataValue;
        }
        if (n3 >= this.getLength() - n2) {
            byte[] byArray = new byte[this.dataValue.length - n2];
            System.arraycopy(this.dataValue, n2, byArray, 0, byArray.length);
            bitDataValue.setValue(byArray);
        } else {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.dataValue, n2, byArray, 0, byArray.length);
            bitDataValue.setValue(byArray);
        }
        return bitDataValue;
    }

    public final void checkHostVariable(int n) throws StandardException {
        int n2 = -1;
        if (this._blobValue != null) {
            n2 = -1;
        } else if (this.stream == null) {
            if (this.dataValue != null) {
                n2 = this.dataValue.length;
            }
        } else {
            n2 = this.streamValueLength;
        }
        if (n2 != -1 && n2 > n) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)MessageService.getTextMessage("BIN01"), (Object)String.valueOf(n));
        }
    }

    public final String toString() {
        if (this.dataValue == null) {
            if (this.stream == null && this._blobValue == null) {
                return "NULL";
            }
            return "";
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final int hashCode() {
        int n;
        try {
            if (this.getValue() == null) {
                return 0;
            }
        }
        catch (StandardException standardException) {
            return 0;
        }
        byte[] byArray = this.dataValue;
        for (n = byArray.length - 1; n >= 0 && byArray[n] == 32; --n) {
        }
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            n2 = n2 * 31 + byArray[i];
        }
        return n2;
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = byArray.length;
        byte[] byArray3 = byArray2;
        if (byArray2.length < n3) {
            n3 = byArray2.length;
            byArray3 = byArray;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = byArray[n2] & 0xFF;
            int n4 = byArray2[n2] & 0xFF;
            if (n == n4) continue;
            return n - n4;
        }
        for (n2 = n3; n2 < byArray3.length; ++n2) {
            n = byArray3[n2];
            if (n == 32) continue;
            if (byArray == byArray3) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setBytes(n, this.getBytes());
    }

    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.hasStream()) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + ":Length=" + this.getLength();
    }

    private int getBlobLength() throws StandardException {
        try {
            long l = Integer.MAX_VALUE;
            long l2 = this._blobValue.length();
            if (l2 > Integer.MAX_VALUE) {
                throw StandardException.newException("XJ093.S", (Object)Long.toString(l2), (Object)Long.toString(l));
            }
            return (int)l2;
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
    }

    void truncate(int n, int n2, boolean bl) throws StandardException {
        Object object;
        if (bl) {
            object = new DataTruncation(-1, false, true, this.getLength(), n2);
            StatementContext statementContext = (StatementContext)ContextService.getContext("StatementContext");
            statementContext.getActivation().getResultSet().addWarning((SQLWarning)object);
        }
        object = new byte[n2];
        System.arraycopy(this.getValue(), 0, object, 0, n2);
        this.setValue((byte[])object);
    }
}

