/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;

public class JoinToMultiJoinRule
extends RelOptRule {
    public static final JoinToMultiJoinRule INSTANCE = new JoinToMultiJoinRule(LogicalJoin.class);

    public JoinToMultiJoinRule(Class<? extends Join> clazz) {
        super(JoinToMultiJoinRule.operand(clazz, JoinToMultiJoinRule.operand(RelNode.class, JoinToMultiJoinRule.any()), JoinToMultiJoinRule.operand(RelNode.class, JoinToMultiJoinRule.any())));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        ArrayList projFieldsList = Lists.newArrayList();
        ArrayList joinFieldRefCountsList = Lists.newArrayList();
        List<RelNode> newInputs = this.combineInputs(origJoin, (RelNode)left, (RelNode)right, projFieldsList, joinFieldRefCountsList);
        ArrayList joinSpecs = Lists.newArrayList();
        this.combineOuterJoins(origJoin, newInputs, (RelNode)left, (RelNode)right, joinSpecs);
        List<RexNode> newJoinFilters = this.combineJoinFilters(origJoin, (RelNode)left, (RelNode)right);
        ImmutableMap<Integer, ImmutableIntList> newJoinFieldRefCountsMap = this.addOnJoinFieldRefCounts(newInputs, origJoin.getRowType().getFieldCount(), origJoin.getCondition(), joinFieldRefCountsList);
        List<RexNode> newPostJoinFilters = this.combinePostJoinFilters(origJoin, (RelNode)left, (RelNode)right);
        RexBuilder rexBuilder = origJoin.getCluster().getRexBuilder();
        MultiJoin multiJoin = new MultiJoin(origJoin.getCluster(), newInputs, RexUtil.composeConjunction(rexBuilder, newJoinFilters, false), origJoin.getRowType(), origJoin.getJoinType() == JoinRelType.FULL, Pair.right(joinSpecs), Pair.left(joinSpecs), projFieldsList, newJoinFieldRefCountsMap, RexUtil.composeConjunction(rexBuilder, newPostJoinFilters, true));
        call.transformTo(multiJoin);
    }

    private List<RelNode> combineInputs(Join join, RelNode left, RelNode right, List<ImmutableBitSet> projFieldsList, List<int[]> joinFieldRefCountsList) {
        int i;
        ArrayList newInputs = Lists.newArrayList();
        if (this.canCombine(left, join.getJoinType().generatesNullsOnLeft())) {
            MultiJoin leftMultiJoin = (MultiJoin)left;
            for (i = 0; i < left.getInputs().size(); ++i) {
                newInputs.add(leftMultiJoin.getInput(i));
                projFieldsList.add(leftMultiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(((ImmutableIntList)leftMultiJoin.getJoinFieldRefCountsMap().get((Object)i)).toIntArray());
            }
        } else {
            newInputs.add(left);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[left.getRowType().getFieldCount()]);
        }
        if (this.canCombine(right, join.getJoinType().generatesNullsOnRight())) {
            MultiJoin rightMultiJoin = (MultiJoin)right;
            for (i = 0; i < right.getInputs().size(); ++i) {
                newInputs.add(rightMultiJoin.getInput(i));
                projFieldsList.add(rightMultiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(((ImmutableIntList)rightMultiJoin.getJoinFieldRefCountsMap().get((Object)i)).toIntArray());
            }
        } else {
            newInputs.add(right);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[right.getRowType().getFieldCount()]);
        }
        return newInputs;
    }

    private void combineOuterJoins(Join joinRel, List<RelNode> combinedInputs, RelNode left, RelNode right, List<Pair<JoinRelType, RexNode>> joinSpecs) {
        JoinRelType joinType = joinRel.getJoinType();
        boolean leftCombined = this.canCombine(left, joinType.generatesNullsOnLeft());
        boolean rightCombined = this.canCombine(right, joinType.generatesNullsOnRight());
        switch (joinType) {
            case LEFT: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoin)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                break;
            }
            case RIGHT: {
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoin)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                break;
            }
            default: {
                if (leftCombined) {
                    this.copyOuterJoinInfo((MultiJoin)left, joinSpecs, 0, null, null);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, null));
                }
                if (rightCombined) {
                    this.copyOuterJoinInfo((MultiJoin)right, joinSpecs, left.getRowType().getFieldCount(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList());
                    break;
                }
                joinSpecs.add(Pair.of(JoinRelType.INNER, null));
            }
        }
    }

    private void copyOuterJoinInfo(MultiJoin multiJoin, List<Pair<JoinRelType, RexNode>> destJoinSpecs, int adjustmentAmount, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields) {
        List<Pair<JoinRelType, RexNode>> srcJoinSpecs = Pair.zip(multiJoin.getJoinTypes(), multiJoin.getOuterJoinConditions());
        if (adjustmentAmount == 0) {
            destJoinSpecs.addAll(srcJoinSpecs);
        } else {
            int nFields = srcFields.size();
            int[] adjustments = new int[nFields];
            for (int idx = 0; idx < nFields; ++idx) {
                adjustments[idx] = adjustmentAmount;
            }
            for (Pair<JoinRelType, RexNode> src : srcJoinSpecs) {
                destJoinSpecs.add(Pair.of(src.left, src.right == null ? null : ((RexNode)src.right).accept(new RelOptUtil.RexInputConverter(multiJoin.getCluster().getRexBuilder(), srcFields, destFields, adjustments))));
            }
        }
    }

    private List<RexNode> combineJoinFilters(Join joinRel, RelNode left, RelNode right) {
        JoinRelType joinType = joinRel.getJoinType();
        ArrayList filters = Lists.newArrayList();
        if (joinType != JoinRelType.LEFT && joinType != JoinRelType.RIGHT) {
            filters.add(joinRel.getCondition());
        }
        if (this.canCombine(left, joinType.generatesNullsOnLeft())) {
            filters.add(((MultiJoin)left).getJoinFilter());
        }
        if (this.canCombine(right, joinType.generatesNullsOnRight())) {
            MultiJoin multiJoin = (MultiJoin)right;
            filters.add(this.shiftRightFilter(joinRel, left, multiJoin, multiJoin.getJoinFilter()));
        }
        return filters;
    }

    private boolean canCombine(RelNode input, boolean nullGenerating) {
        return input instanceof MultiJoin && !((MultiJoin)input).isFullOuterJoin() && !((MultiJoin)input).containsOuter() && !nullGenerating;
    }

    private RexNode shiftRightFilter(Join joinRel, RelNode left, MultiJoin right, RexNode rightFilter) {
        if (rightFilter == null) {
            return null;
        }
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnRight];
        for (int i = 0; i < nFieldsOnRight; ++i) {
            adjustments[i] = nFieldsOnLeft;
        }
        rightFilter = rightFilter.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList(), adjustments));
        return rightFilter;
    }

    private ImmutableMap<Integer, ImmutableIntList> addOnJoinFieldRefCounts(List<RelNode> multiJoinInputs, int nTotalFields, RexNode joinCondition, List<int[]> origJoinFieldRefCounts) {
        int[] joinCondRefCounts = new int[nTotalFields];
        joinCondition.accept(new InputReferenceCounter(joinCondRefCounts));
        HashMap refCountsMap = Maps.newHashMap();
        int nInputs = multiJoinInputs.size();
        int currInput = 0;
        for (int[] origRefCounts : origJoinFieldRefCounts) {
            refCountsMap.put(currInput, origRefCounts.clone());
            ++currInput;
        }
        currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int i = 0; i < nTotalFields; ++i) {
            if (joinCondRefCounts[i] == 0) continue;
            while (i >= startField + nFields) {
                startField += nFields;
                assert (++currInput < nInputs);
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            int[] refCounts = (int[])refCountsMap.get(currInput);
            int n = i - startField;
            refCounts[n] = refCounts[n] + joinCondRefCounts[i];
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : refCountsMap.entrySet()) {
            builder.put(entry.getKey(), (Object)ImmutableIntList.of((int[])entry.getValue()));
        }
        return builder.build();
    }

    private List<RexNode> combinePostJoinFilters(Join joinRel, RelNode left, RelNode right) {
        ArrayList filters = Lists.newArrayList();
        if (right instanceof MultiJoin) {
            MultiJoin multiRight = (MultiJoin)right;
            filters.add(this.shiftRightFilter(joinRel, left, multiRight, multiRight.getPostJoinFilter()));
        }
        if (left instanceof MultiJoin) {
            filters.add(((MultiJoin)left).getPostJoinFilter());
        }
        return filters;
    }

    private class InputReferenceCounter
    extends RexVisitorImpl<Void> {
        private final int[] refCounts;

        public InputReferenceCounter(int[] refCounts) {
            super(true);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int n = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

